#include <algorithm>
#ifndef __GNUC__
#include <ios>
#endif
#include <iomanip>
#include <iostream>
#include <stdexcept>
#include <vector>

#include "Ref_handle.h"
#include "Student_info.h"

using std::cin;
using std::cout;
using std::domain_error;
using std::endl;
using std::sort;
using std::streamsize;
using std::setprecision;
using std::setw;
using std::string;
using std::vector;

#ifdef _MSC_VER
#include "../minmax.h"
#else
using std::max;
#endif

bool compare_Core_handles(const Ref_handle<Core>& lhs, const Ref_handle<Core>& rhs) {
	return compare(*lhs, *rhs);
}
int main()
{
	vector< Ref_handle<Core> > students;       // zmieniony typ
	Ref_handle<Core> record;                   // zmieniony typ
	char ch;
	string::size_type maxlen = 0;

	// wczytaj i zapamitaj dane studenta
	while (cin >> ch) {
		if (ch == 'U')
			record = new Core;      // przydziel obiekt klasy Core
		else
			record = new Grad;      // przydziel obiekt klasy Grad

		record->read(cin);  //  dereferencja Ref_handle<T>::-> i wirtualne wywoanie metody read
		maxlen = max(maxlen, record->name().size()); // Ref_handle<T>::->
		students.push_back(record);
	}

	// funkcja compare musi zposta dostosowana do wsppracy z argumentami typu const Ref_handle<Core>&'
	sort(students.begin(), students.end(), compare_Core_handles);

	// wypisz imiona i oceny
#ifdef _MSC_VER
	for (std::vector< Ref_handle<Core> >::size_type i = 0;
#else
	for (vector< Ref_handle<Core> >::size_type i = 0;
#endif
	     i != students.size(); ++i) {
		// students[i] to obiekt typu Ref_handle -- przed wywoaniem jego metod poddajemy go dereferencji
		cout << students[i]->name()
		     << string(maxlen + 1 - students[i]->name().size(), ' ');
		try {
			double final_grade = students[i]->grade();
			streamsize prec = cout.precision();
			cout << setprecision(3) << final_grade
			     << setprecision(prec) << endl;
		} catch (domain_error e) {
			cout << e.what() << endl;
		}
		// brak instrukcji delete
	}
	return 0;
}

