#ifdef _MSC_VER
#pragma warning(disable:4503)      // ucisza komunikaty kompilatora o zbyt dugich nazwach
#endif

#include <algorithm>
#include <cstdlib>
#include <iostream>
#include <map>
#include <stdexcept>
#include <string>
#include <vector>

#include "split.h"
#include <time.h>

using std::istream;           using std::cin;
using std::copy;              using std::cout;
using std::endl;              using std::find;
using std::getline;           using std::logic_error;
using std::map;               using std::string;
using std::vector;            using std::domain_error;
using std::rand;

typedef vector<string> Rule;
typedef vector<Rule> Rule_collection;
typedef map<string, Rule_collection> Grammar;

// wczytaj gramatyk ze wskazanego strumienia wejciowego
Grammar read_grammar(istream& in)
{
	Grammar ret;
	string line;

	// wczytaj dane z wejcia
	while (getline(in, line)) {

		// podziel cig na wyrazy funkcj split
		vector<string> entry = split(line);

		if (!entry.empty())
		// wykorzystaj kategori do zapamitania skojarzonej z ni reguy
			ret[entry[0]].push_back(
				Rule(entry.begin() + 1, entry.end()));
	}
	return ret;
}

void gen_aux(const Grammar&, const string&, vector<string>&);

int nrand(int);

vector<string> gen_sentence(const Grammar& g)
{
	vector<string> ret;
	gen_aux(g, "<zdanie>", ret);
	return ret;
}

bool bracketed(const string& s)
{
	return s.size() > 1 && s[0] == '<' && s[s.size() - 1] == '>';
}

void
gen_aux(const Grammar& g, const string& word, vector<string>& ret)
{

	if (!bracketed(word)) {
		ret.push_back(word);
	} else {
		// wyszukaj regu odpowiadajc przekazanej kategorii
		Grammar::const_iterator it = g.find(word);
		if (it == g.end())
			throw logic_error("regua jest pusta");

        // pobierz zestaw moliwych regu
		const Rule_collection& c = it->second;

        // wybierz jedn regu w sposb losowy
		const Rule& r = c[nrand(c.size())];

        // rekurencyjnie rozwi wybran regu
		for (Rule::const_iterator i = r.begin(); i != r.end(); ++i)
			gen_aux(g, *i, ret);
	}
}

int main()
{
	// generuj zdanie
	vector<string> sentence = gen_sentence(read_grammar(cin));

	// wypisz pierwsze sowo zdania
#ifdef _MSC_VER
	std::vector<string>::const_iterator it = sentence.begin();
#else
	vector<string>::const_iterator it = sentence.begin();
#endif
	if (!sentence.empty()) {
		cout << *it;
		++it;
	}

	// wypisz pozostae sowa, kade oddzielone od poprzedniego znakiem spacji
	while (it != sentence.end()) {
		cout << " " << *it;
		++it;
	}

	cout << endl;
	return 0;
}

// zwr losow liczb cakowit z zakresu [0, n)
int nrand(int n)
{
	if (n <= 0 || n > RAND_MAX)
		throw domain_error("Argument funkcji nrand spoza zakresu losowego");

	const int bucket_size = RAND_MAX / n;
	int r;

	do r = rand() / bucket_size;
	while (r >= n);

	return r;
}

