#include <cctype>
#include <string>
#include <vector>

#include "split.h"

using std::vector;
using std::string;

#ifndef _MSC_VER
using std::isspace;
#endif

vector<string> split(const string& s)
{
	vector<string> ret;
	typedef string::size_type string_size;
	string_size i = 0;

	// niezmiennik: przetworzylimy [warto pocztkowa i, i)
	while (i != s.size()) {
		// pomi ewentualne pocztkowe odstpy
		// niezmiennik: znaki w zakresie [pocztkowe i, biece i) to znaki odstpu
		while (i != s.size() && isspace(s[i]))
			++i;

		// wyszukaj nastpny wyraz
		string_size j = i;
		// niezmiennik: aden ze znakw w zakresie [i, j) nie jest znakiem odstpu
		while (j != s.size() && !isspace(s[j]))
			++j;

		// jeeli znaleziono jakie znaki nie bdce odstpami
		if (i != j) {
			// kopiuj z cigu s od znaku i j - i znakw
			ret.push_back(s.substr(i, j - i));
			i = j;
		}

	}
	return ret;
}

