#include <algorithm>
#include <string>
#include <vector>

#include "pics.h"

using std::string;
using std::vector;

#ifdef _MSC_VER
#include "../minmax.h"
#else
using std::max;
#endif

string::size_type width(const vector<string>& v)
{
	string::size_type maxlen = 0;
#ifdef _MSC_VER
	for(std::vector<string>::size_type i = 0; i != v.size(); ++i)
#else
	for(vector<string>::size_type i = 0; i != v.size(); ++i)
#endif
		maxlen = max(maxlen, v[i].size());
	return maxlen;
}

vector<string> frame(const vector<string>& v)
{
	vector<string> ret;
	string::size_type maxlen = width(v);
	string border(maxlen + 4, '*');

	// wypisz grn ramk
	ret.push_back(border);

	// wypisz wiersze wewntrzne, otoczone spacjami i gwiazdkami
#ifdef _MSC_VER
	for (std::vector<string>::size_type i = 0; i != v.size(); ++i) {
#else
	for (vector<string>::size_type i = 0; i != v.size(); ++i) {
#endif
		ret.push_back("* " + v[i] +
		              string(maxlen - v[i].size(), ' ') + " *");
	}

	// wypisz ramk doln
	ret.push_back(border);
	return ret;
}

vector<string> vcat(const vector<string>& top,
                    const vector<string>& bottom)
{
	// kopiuj obrazek grny (top)
	vector<string> ret = top;

	// kopiuj zawarto obrazka dolnego (bottom)
#ifdef _MSC_VER
	for (std::vector<string>::const_iterator it = bottom.begin();
#else
	for (vector<string>::const_iterator it = bottom.begin();
#endif
	     it != bottom.end(); ++it)
		ret.push_back(*it);

	return ret;
}

vector<string>
hcat(const vector<string>& left, const vector<string>& right)
{
	vector<string> ret;

	// dodaj 1 do szerokoci obrazka lewego (spacja oddzielajca obrazki rdowe)
	string::size_type width1 = width(left) + 1;

	// indeksy elementw obrazkw lewego (i) i prawego (j)
#ifdef _MSC_VER
	std::vector<string>::size_type i = 0, j = 0;
#else
	vector<string>::size_type i = 0, j = 0;
#endif

	// kontynuuj a do momentu przetworzenia wszystkich wierszy obu obrazkw
	while (i != left.size() || j != right.size()) {
		// konstruuj nowy obiekt typu string przechowujcy znaki z obu rysunkw rdowych
		string s;

		// kopiuj wiersz z obrazka lewego (o ile taki wiersz istnieje)
		if (i != left.size())
			s = left[i++];

		// uzupenij znakami spacji
		s += string(width1 - s.size(), ' ');

		// kopiuj wiersz z obrazka prawego (o ile taki wiersz istnieje)
		if (j != right.size())
			s += right[j++];

		// dodaj s do kontenera obrazka wynikowego
		ret.push_back(s);
	}

	return ret;
}

