#ifndef GUARD_Ptr_h
#define GUARD_Ptr_h

#include <cstddef>
#include <stdexcept>

template <class T> class Ptr {
public:
	// nowa metoda warunkowo kopiujca obiekt
	void make_unique() {
		if (*refptr != 1) {
			--*refptr;
			refptr = new size_t(1);
			p = p? clone(p): 0;
		}
	}

	// reszta klasy jest ywcem przeniesiona z Ref_handle; zmienia si tylko nazwa klasy
	Ptr(): p(0), refptr(new size_t(1)) { }
	Ptr(T* t): p(t), refptr(new size_t(1)) { }
	Ptr(const Ptr& h): p(h.p), refptr(h.refptr) { ++*refptr; }

	Ptr& operator=(const Ptr&);         // implementacja jak w 14.2/261
 	~Ptr();                             // implementacja jak w 14.2/262
 	operator bool() const { return p; }
 	T& operator*() const;               // implementacja jak w 14.2/261
 	T* operator->() const;              // implementacja jak w 14.2/261

private:
	T* p;
#ifdef _MSC_VER
	size_t* refptr;
#else
	std::size_t* refptr;
#endif
};

template <class T> T* clone(const T* tp)
{
	return tp->clone();
}



template<class T>
T& Ptr<T>::operator*() const { if (p) return *p; throw std::runtime_error("niedowizany wskanik Ptr"); }

template<class T>
T* Ptr<T>::operator->() const { if (p) return p; throw std::runtime_error("niedowizany wskanik Ptr"); }


template<class T>
Ptr<T>& Ptr<T>::operator=(const Ptr& rhs)
{
        ++*rhs.refptr;
        // zwolnij lewy operand, usuwajc wskanik
        if (--*refptr == 0) {
                delete refptr;
                delete p;
        }

        // skopiuj warto lewego operandu
        refptr = rhs.refptr;
        p = rhs.p;
        return *this;
}

template<class T> Ptr<T>::~Ptr()
{
        if (--*refptr == 0) {
                delete refptr;
                delete p;
        }
}


#endif
