// plik kodu rdowego funkcji `median'
#include <algorithm>    // deklaracja funkcji `sort'
#include <stdexcept>    // deklaracja wyjtku `domain_error'
#include <vector>       // deklaracja kontenera `vector'

using std::domain_error;   using std::sort;   using std::vector;

#include "median.h"

// oblicz median zbioru wartoci z kontenera vector<double>
// zauwa, e wywoanie funkcji kopiuje cao argumentu typu vector
double median(vector<double> vec)
{
#ifdef _MSC_VER
	typedef std::vector<double>::size_type vec_sz;
#else
	typedef vector<double>::size_type vec_sz;
#endif

	vec_sz size = vec.size();
	if (size == 0)
		throw domain_error("obliczanie mediany zbioru pustego");

	sort(vec.begin(), vec.end());

	vec_sz mid = size/2;

	return size % 2 == 0 ? (vec[mid] + vec[mid-1]) / 2 : vec[mid];
}

