#include <algorithm>
#include <iomanip>
#ifndef __GNUC__
#include <ios>
#endif
#include <iostream>
#include <string>
#include <vector>

using std::cin;             using std::sort;
using std::cout;            using std::streamsize;
using std::endl;            using std::string;
using std::setprecision;    using std::vector;

int main()
{
	// zapytaj o imi studenta
	cout << "Podaj swoje imi: ";
	string name;
	cin >> name;
	cout << "Witaj, " << name << "!" << endl;

	// zapytaj o oceny z kolokwiw i ocen z egzaminu kocowego
	cout << "Wprowad swoje oceny porednie i ocen z egzaminu: ";
	double midterm, final;
	cin >> midterm >> final;

	// zapytaj o oceny zada domowych
	cout << "Wprowad wszystkie posiadane oceny zada domowych, "
	        "list ocen zakocz znakiem koca pliku: ";

	vector<double> homework;
	double x;
	// niezmiennik: homework zawiera wszystkie odczytane do tej pory oceny
	while (cin >> x)
		homework.push_back(x);

	// sprawd, czy student poda jakie oceny
#ifdef _MSC_VER
	typedef std::vector<double>::size_type vec_sz;
#else
	typedef vector<double>::size_type vec_sz;
#endif
	vec_sz size = homework.size();
	if (size == 0) {
		cout << endl << "Musisz wprowadzi oceny. Sprbuj jeszcze raz." << endl;	
		return 1;
	}

	// posortuj oceny
	sort(homework.begin(), homework.end());

	// oblicz median ocen zada domowych
	vec_sz mid = size/2;
	double median;
	median = size % 2 == 0 ? (homework[mid] + homework[mid-1]) / 2
	                       : homework[mid];

	// oblicz i wyprowad ocen kocow studenta
	streamsize prec = cout.precision();
	cout << "Twoja ocena semestralna to " << setprecision(3)
	     << 0.2 * midterm + 0.4 * final + 0.4 * median
	     << setprecision(prec) << endl;

	return 0;
}

