#include <algorithm>
#ifndef __GNUC__
#include <ios>
#endif
#include <iomanip>
#include <iostream>
#include <stdexcept>
#include <vector>

#include "Ptr.h"
#include "Student_info.h"

using std::cin;
using std::cout;
using std::domain_error;
using std::endl;
using std::sort;
using std::streamsize;
using std::setprecision;
using std::setw;
using std::string;
using std::vector;

#ifdef _MSC_VER
#include "../minmax.h"
#else
using std::max;
#endif

bool compare_Core_handles(const Ptr<Core>& lhs, const Ptr<Core>& rhs) {
	return compare(*lhs, *rhs);
}
int main()
{
	vector< Ptr<Core> > students;       // zmieniony typ
	Ptr<Core> record;                   // zmieniony typ
	char ch;
	string::size_type maxlen = 0;

	// wczytaj i zapamitaj dane studenta
	while (cin >> ch) {
		if (ch == 'U')
			record = new Core;      // przydziel obiekt klasy Core
		else
			record = new Grad;      // przydziel obiekt klasy Grad

		record->read(cin);  //  dereferencja Ptr<T>::-> i wirtualne wywoanie metody read
		maxlen = max(maxlen, record->name().size()); // Ptr<T>::->
		students.push_back(record);
	}

	// funkcja compare musi zposta dostosowana do wsppracy z argumentami typu const Ptr<Core>&'
	sort(students.begin(), students.end(), compare_Core_handles);

	// wypisz imiona i oceny
#ifdef _MSC_VER
	for (std::vector< Ptr<Core> >::size_type i = 0;
#else
	for (vector< Ptr<Core> >::size_type i = 0;
#endif
	     i != students.size(); ++i) {
		// students[i] to obiekt typu Ptr; po jego dereferencji wywoywana jest waciwa metoda
		cout << students[i]->name()
		     << string(maxlen + 1 - students[i]->name().size(), ' ');
		try {
			double final_grade = students[i]->grade();
			streamsize prec = cout.precision();
			cout << setprecision(3) << final_grade
			     << setprecision(prec) << endl;
		} catch (domain_error e) {
			cout << e.what() << endl;
		}
		// brak instrukcji delete
	}
	return 0;
}

