#include <map>
#include <iostream>
#include <string>
#include <vector>

#include "split.h"

using std::cin;            using std::cout;
using std::endl;           using std::getline;
using std::istream;        using std::string;
using std::vector;         using std::map;

// wyszukaj numery wierszy, w ktrych pojawi si wyraz
map<string, vector<int> >
	xref(istream& in,
	     vector<string> find_words(const string&) = split)
{
	string line;
	int line_number = 0;
	map<string, vector<int> > ret;

	// wczytaj nastpny wiersz
	while (getline(in, line)) {
		++line_number;

		// podziel wiersz na wyrazy
		vector<string> words = find_words(line);

		// zapamitaj numer wiersza dla wszystkich wyrazw tego wiersza
#ifdef _MSC_VER
		for (std::vector<string>::const_iterator it = words.begin();
#else
		for (vector<string>::const_iterator it = words.begin();
#endif
		     it != words.end(); ++it)
			ret[*it].push_back(line_number);
	}
	return ret;
}

int main()
{
	// wywoaj funkcj xref z funkcj split (warto domylna)
	map<string, vector<int> > ret = xref(cin);

	// wypisz wyniki
#ifdef _MSC_VER
	for (std::map<string, vector<int> >::const_iterator it = ret.begin();
#else
	for (map<string, vector<int> >::const_iterator it = ret.begin();
#endif
	     it != ret.end(); ++it) {
		// wypisz wyraz
		cout << it->first << " wystpi w wierszu(wierszach): ";

		// a za nim jeden lub kilka numerw wierszy
#ifdef _MSC_VER
		std::vector<int>::const_iterator line_it = it->second.begin();
#else
		vector<int>::const_iterator line_it = it->second.begin();
#endif
		cout << *line_it;	// wypisz pierwszy numer wiersza

		++line_it;
		// wypisz reszt numerw wierszy
		while (line_it != it->second.end()) {
			cout << ", " << *line_it;
			++line_it;
		}
		// wypisz znak nowego wiersza (oddziel kolejne wyrazy)
		cout << endl;
	}

	return 0;
}

