#include <vector>
#include <string>
#include <algorithm>
#include <iomanip>

#ifndef __GNUC__
#include <ios>
#endif

#include <iostream>
#include <stdexcept>

#include "Core.h"

using std::cout;
using std::cin;
using std::domain_error;
using std::endl;
using std::setprecision;
using std::setw;
using std::streamsize;
using std::sort;
using std::string;
using std::vector;

#ifdef _MSC_VER
#include "../minmax.h"
#else
using std::max;
#endif

// ten kod ju prawie dziaa; patrz 13.3.2
int main()
{
	vector<Core*> students;               // przechowuje nie obiekty, a wskaniki
 	Core* record;                         // zmienna tymczasowa rwnie musi by wskanikiem
	char ch;
	string::size_type maxlen = 0;

	// wczytaj i zapamitaj dane
	while (cin >> ch) {
		if (ch == 'U')
			record = new Core;      // przydziel obiekt typu Core
		else
			record = new Grad;      // przydziel obiekt typu Grad
		record->read(cin);          // wywoanie metody wirtualnej
		maxlen = max(maxlen, record->name().size());// dereferencja
		students.push_back(record);
	}

	// uporzdkuj wpisy alfabetycznie za pomoc nowej wersji funkcji porwnujcej
	sort(students.begin(), students.end(), compare_Core_ptrs);

	// wypisz nazwiska i oceny
#ifdef _MSC_VER
	for (std::vector<Core*>::size_type i = 0;
#else
	for (vector<Core*>::size_type i = 0;
#endif
	     i != students.size(); ++i) {
		// students[i] to wskanik; przed wywoaniem metody trzeba podda go dereferencji
		cout << students[i]->name()
		     << string(maxlen + 1 - students[i]->name().size(), ' ');
		try {
			double final_grade = students[i]->grade();
			streamsize prec = cout.precision();
			cout << setprecision(3) << final_grade
			     << setprecision(prec) << endl;

		} catch (domain_error e) {
			cout << e.what() << endl;
		}
		delete students[i];          // zwolnij obiekt przydzielony przy odczycie
	}
	return 0;
}

