#include <algorithm>
#include <iomanip>
#include <iostream>
#include <stdexcept>
#include "Str.h"
#include "Vec.h"

#ifdef _MSC_VER
#include "../minmax.h"
#else
using std::max;
#endif

using std::cin;
using std::cout;
using std::domain_error;
using std::endl;
using std::istream;
using std::ostream;
using std::setprecision;
using std::setw;
using std::sort;
using std::streamsize;



struct Student_info {
	Str name;
	double midterm, final;
	Vec<double> homework;
};	// uwaga na rednik -- jest wymagany!

// oblicz median elementw kontenera `Vec<double>'
// zauwa, e wywoanie tej funkcji kopiuje cao kontenera typu `Vec'
double median(Vec<double> vec)
{
#ifdef _MSC_VER
	typedef Vec<double>::size_type vec_sz;
#else
	typedef Vec<double>::size_type vec_sz;
#endif

	vec_sz size = vec.size();
	if (size == 0)
		throw domain_error("obliczanie mediany zbioru pustego (Vec)");

	sort(vec.begin(), vec.end());

	vec_sz mid = size/2;

	return size % 2 == 0 ? (vec[mid] + vec[mid-1]) / 2 : vec[mid];
}

// oblicz ocen kocow studenta na podstawie oceny rdsemestralnej
// i oceny egzaminu kocowego oraz oceny pracy domowych
double grade(double midterm, double final, double homework)
{
	return 0.2 * midterm + 0.4 * final + 0.4 * homework;
}

// oblicz ocen kocow studenta na podstawie oceny rdsemestralnej i oceny egzaminu kocowego
// oraz wektora (Vec) ocen prac domowych.
// funkcja nie kopiuje argumentu wywoania, poniewa kopiowanie odbywa si w funkcji `median'.
double grade(double midterm, double final, const Vec<double>& hw)
{
	if (hw.size() == 0)
		throw domain_error("student nie odrobi prac domowych");
	return grade(midterm, final, median(hw));
}

double grade(const Student_info& s)
{
	return grade(s.midterm, s.final, s.homework);
}

// wczytaj oceny prac domowych ze standardowego wejcia do kontenera typu `Vec<double>'
istream& read_hw(istream& in, Vec<double>& hw)
{
	if (in) {
		// pozbd si ewentualnych "mieci" w kontenerze
		hw.clear();

		// wczytaj oceny
		double x;
		while (in >> x)
			hw.push_back(x);

		// wyzeruj strumie tak, aby dao si poprawnie wczyta oceny kolejnego studenta
		in.clear();
	}
	return in;
}

istream& read(istream& is, Student_info& s)
{
	// wczytaj i zapamitaj imi studenta i jego ocen rdsemestraln i ocen egzaminu kocowego
	is >> s.name >> s.midterm >> s.final;

	read_hw(is, s.homework);  // wczytaj i zapamitaj w kontenerze pceny prac domowych studenta
	return is;
}

bool compare(const Student_info& x, const Student_info& y)
{
	return x.name < y.name;
}

int main()
{
	Vec<Student_info> students;
	Student_info record;
	Str::size_type maxlen = 0;

	// wczytaj wszystkie wpisy studentw, okrelajc przy okazji dugo najduszego imienia
	while (read(cin, record)) {
		maxlen = max(maxlen, record.name.size());
		students.push_back(record);
	}

	// uporzdkuj wpisy alfabetycznie
	sort(students.begin(), students.end(), compare);

#ifdef _MSC_VER
	for (Vec<Student_info>::size_type i = 0;
#else
	for (Vec<Student_info>::size_type i = 0;
#endif
	     i != students.size(); ++i) {

		// wypisz nazwisko i uzupenij spacjami do wymaganego odstpu od kolumny ocen
		cout << students[i].name
		     << Str(maxlen + 1 - students[i].name.size(), ' ');

		// oblicz i wypisz ocen kocow
		try {
			double final_grade = grade(students[i]);
			streamsize prec = cout.precision();
			cout << setprecision(3) << final_grade
			     << setprecision(prec);
		} catch (domain_error e) {
			cout << e.what();
		}

		cout << endl;
	}

	return 0;
}

