#include <algorithm>
#include <cctype>
#include <string>
#include <vector>

#include "urls.h"

using std::find;
using std::find_if;

#ifndef _MSC_VER
using std::isalnum;
using std::isalpha;
using std::isdigit;
#endif

using std::search;
using std::string;
using std::vector;

bool not_url_char(char);

string::const_iterator
url_end(string::const_iterator, string::const_iterator);

string::const_iterator
url_beg(string::const_iterator, string::const_iterator);
vector<string> find_urls(const string& s)
{
	vector<string> ret;
	typedef string::const_iterator iter;
	iter b = s.begin(), e = s.end();

	// przejrzyj cay cig wejciowy
	while (b != e) {

		// poszukaj jednego lub kilku znakw, po ktrych znajduje si podcig ://
		b = url_beg(b, e);

		// jeli udao si znale podcig
		if (b != e) {
			// pobierz reszt URL-a

			iter after = url_end(b, e);

			// zapamitaj znaleziony URL
			ret.push_back(string(b, after));

			// zwiksz b i szukaj nastpnych identyfikatorw
			b = after;
		}
	}
	return ret;
}

string::const_iterator
url_end(string::const_iterator b, string::const_iterator e)
{
	return find_if(b, e, not_url_char);
}

bool not_url_char(char c)
{
	// znaki (poza znakami alfanumerycznymi) dozwolone w identyfikatorach URL
	static const string url_ch = "~;/?:@=&$-_.+!*'(),";

	// sprawd, czy c jest dozwolonym znakiem URL
	return !(isalnum(c) ||
	         find(url_ch.begin(), url_ch.end(), c) != url_ch.end());
}

string::const_iterator
url_beg(string::const_iterator b, string::const_iterator e)
{
	static const string sep = "://";

	typedef string::const_iterator iter;

	// i sygnalizuje odnalezienie separatora ://
	iter i = b;

	while ((i = search(i, e, sep.begin(), sep.end())) != e) {

		// upewnij si, e separator nie rozpoczyna si od pocztku cigu
		if (i != b && i + sep.size() != e) {

			// beg zaznacza pocztek nazwy-protokou
			iter beg = i;
			while (beg != b && isalpha(beg[-1]))
				--beg;

			// czy za i przed separatorem :// znajduje si przynajmniej po jednym znaku?
			if (beg != i && !not_url_char(i[sep.size()]))
				return beg;
		}

		// odnaleziony separator nie jest czci URL-a; zwiksz i poza pozycj ostatniego znaku sepraratora
		i += sep.size();
	}
	return e;
}

