#include <algorithm>
#include <cctype>
#include <string>

using std::find_if;
using std::string;

#ifndef _MSC_VER
using std::isspace;
#endif

inline bool space(char c)
{
        return isspace(c);
}

inline bool not_space(char c)
{
        return !isspace(c);
}

template <class Out>                             // zmiana
void split(const string& str, Out os) {          // zmiana

	typedef string::const_iterator iter;

	iter i = str.begin();
	while (i != str.end()) {
		// pomi znaki spacji na pocztku cigu
		i = find_if(i, str.end(), not_space);

		// znajd kolejny wyraz
		iter j = find_if(i, str.end(), space);

		// kopiuj znaki z zakresu [i, j)
		if (i != str.end())
			*os++ = string(i, j);   // zmiana

		i = j;
	}
}

