#include <algorithm>
#include <cctype>
#include <string>
#include <vector>

#include "split.h"

using std::find_if;
using std::string;
using std::vector;

#ifndef _MSC_VER
using std::isspace;
#endif

// zwraca true jeeli argument jest znakiem odstpu; w przeciwnym przypadku zwraca false
bool space(char c)
{
	return isspace(c);
}

// zwraca false jeeli argument jest znakiem odstpu; w przeciwnym przypadku zwraca true
bool not_space(char c)
{
	return !isspace(c);
}

vector<string> split(const string& str)
{
	typedef string::const_iterator iter;
	vector<string> ret;

	iter i = str.begin();
	while (i != str.end()) {

		// pomi wprowadzajce znaki odstpu
		i = find_if(i, str.end(), not_space);

		// znajd koniec biecego wyrazu
		iter j = find_if(i, str.end(), space);

		// kopiuj znaki z zakresu [i, j)
		if (i != str.end())
			ret.push_back(string(i, j));
		i = j;
	}
	return ret;
}

