#ifndef Ref_handle_h
#define Ref_handle_h

#include <cstddef>
#include <stdexcept>

template <class T> class Ref_handle {
public:
	// zarzdza wskanikiem do obiektu docelowego i licznikiem odwoa
	Ref_handle(): p(0), refptr(new size_t(1)) { }
	Ref_handle(T* t):  p(t), refptr(new size_t(1)) { }
	Ref_handle(const Ref_handle& h): p(h.p), refptr(h.refptr) {
		++*refptr;
	}

	Ref_handle& operator=(const Ref_handle&);
	~Ref_handle();

	// jak dotychczas
	operator bool() const { return p; }
	T& operator*() const {
		if (p)
			return *p;
		throw std::runtime_error("niedowizany obiekt Ref_handle");
	}
	T* operator->() const {
		if (p)
			return p;
		throw std::runtime_error("niedowizany obiekt Ref_handle");
	}

private:
	T* p;
#ifdef _MSC_VER
	size_t* refptr;      // dodane
#else
	std::size_t* refptr;      // dodane
#endif
};

template <class T>
Ref_handle<T>& Ref_handle<T>::operator=(const Ref_handle& rhs)
{
	++*rhs.refptr;
	// zwolnij lewy operand, zwalniajc (o ile zachodzi taka potrzeba) dotychczasowy obiekt docelowy
	if (--*refptr == 0) {
		delete refptr;
		delete p;
	}

	// kopiuj wartoci wskanikw operandu prawego
	refptr = rhs.refptr;
	p = rhs.p;
	return *this;
}

template <class T> Ref_handle<T>::~Ref_handle()
{
	if (--*refptr == 0) {
		delete refptr;
		delete p;
	}
}

#endif
