#include <vector>
#include <stdexcept>

using std::domain_error;
using std::vector;

#include "grade.h"
#include "median.h"

// oblicz ocen kocow studenta na podstawie oceny rdsemestralnej
// i oceny egzaminu kocowego oraz oceny pracy domowych
double grade(double midterm, double final, double homework)
{
	return 0.2 * midterm + 0.4 * final + 0.4 * homework;
}

// oblicz ocen kocow studenta na podstawie oceny rdsemestralnej i oceny egzaminu kocowego
// oraz wektora Vec ocen prac domowych.
// funkcja nie kopiuje argumentu wywoania, poniewa kopiowanie odbywa si w funkcji `median'.
double grade(double midterm, double final, const vector<double>& hw)
{
	if (hw.size() == 0)
		throw domain_error("student nie odrobi prac domowych");
	return grade(midterm, final, median(hw));
}

