#include <algorithm>
#include <iomanip>
#ifndef __GNUC__
#include <ios>
#endif
#include <iostream>
#include <stdexcept>
#include "Str.h"
#include "Vec.h"
#include "grade.h"
#include "Student_info.h"

using std::cin;                     using std::setprecision;
using std::cout;                    using std::sort;
using std::domain_error;            using std::streamsize;
using std::endl;
#ifndef _MSC_VER
using std::max;
#else


#include "../minmax.h"
#endif

int main()
{
	Vec<Student_info> students;
	Student_info record;
	Str::size_type maxlen = 0;       // dugo najduszego imienia

	// wczytaj i zapamitaj dane studentw
	// niezmiennik: students zawiera wszystkie odczytane do tej pory wpisy studentw
 	//              maxlen zawiera dugo najduszego wczytanego dotd nazwiska
	while (read(cin, record)) {
		// szukaj najduszego nazwiska
		maxlen = max(maxlen, record.name.size());
		students.push_back(record);
	}

	// uszereguj wpisy studentw alfabetycznie
	sort(students.begin(), students.end(), compare);

	// wypisz nazwiska i oceny kocowe studentw
#ifdef _MSC_VER
	for (Vec<Student_info>::size_type i = 0;
#else
	for (Vec<Student_info>::size_type i = 0;
#endif
	     i != students.size(); ++i) {

      	// wypisz nazwisko i uzupenij spacjami do wymaganego odstpu od kolumny ocen
		cout << students[i].name
		     << Str(maxlen + 1 - students[i].name.size(), ' ');

		// oblicz i wypisz ocen kocow
		try {
			double final_grade = grade(students[i]);
			streamsize prec = cout.precision();
			cout << setprecision(3) << final_grade
			     << setprecision(prec);
		} catch (domain_error e) {
			cout << e.what();
		}
		cout << endl;
	}
	return 0;
}

