#include <algorithm>
#include <iomanip>
#include <iostream>
#include <stdexcept>
#include <string>
#include <vector>

using std::cin;
using std::cout;
using std::domain_error;
using std::endl;
using std::istream;
using std::ostream;
using std::setprecision;
using std::sort;
using std::streamsize;
using std::string;
using std::vector;

// oblicz median elementw kontenera vector<double>
// zauwa, e wywoanie tej funkcji kopiuje cay argument typu `vector<double>'
double median(vector<double> vec)
{
#ifdef _MSC_VER
	typedef std::vector<double>::size_type vec_sz;
#else
	typedef vector<double>::size_type vec_sz;
#endif

	vec_sz size = vec.size();
	if (size == 0)
		throw domain_error("obliczanie mediany zbioru pustego");

	sort(vec.begin(), vec.end());

	vec_sz mid = size/2;

	return size % 2 == 0 ? (vec[mid] + vec[mid-1]) / 2 : vec[mid];
}

// oblicz ocen kocow studenta na podstawie oceny rdsemestralnej
// i oceny egzaminu kocowego oraz oceny pracy domowych
double grade(double midterm, double final, double homework)
{
	return 0.2 * midterm + 0.4 * final + 0.4 * homework;
}

// oblicz ocen kocow studenta na podstawie oceny rdsemestralnej i oceny egzaminu kocowego
// oraz wektora ocen prac domowych.
// funkcja nie kopiuje argumentu wywoania, poniewa kopiowanie odbywa si w funkcji `median'.
double grade(double midterm, double final, const vector<double>& hw)
{
	if (hw.size() == 0)
		throw domain_error("student nie odrobi prac domowych");
	return grade(midterm, final, median(hw));
}

// wczytaj oceny prac domowych ze standardowego wejciado kontenera typu `vector<double>'
istream& read_hw(istream& in, vector<double>& hw)
{
	if (in) {
		// pozbd si ewentualnych "mieci" w kontenerze
		hw.clear();

		// wczytaj oceny
		double x;
		while (in >> x)
			hw.push_back(x);

		// wyzeruj strumie tak, aby dao si poprawnie wczyta oceny kolejnego studenta
		in.clear();
	}
	return in;
}


int main()
{
	// zapytaj studenta o imi
	cout << "Podaj prosz swoje imi: ";
	string name;
	cin >> name;
	cout << "Witaj, " << name << "!" << endl;

	// zapytaj o i zapamtaj oceny rodsemestraln i egzaminu kocowego
	cout << "Wprowad ocen rdsemestraln i ocen egzaminu kocowego: ";
	double midterm, final;
	cin >> midterm >> final;

	// zapytaj o ocen rdsemestraln i ocen z egzaminu kocowego
	cout << "Wprowad wszystkie posiadane oceny zada domowych, "
	        "list ocen zakocz znakiem koca pliku: ";

	vector<double> homework;

	// wczytaj oceny prac domowych
	read_hw(cin, homework);

	// sprbuj obliczy i wypisa ocen kocow
	try {
		double final_grade = grade(midterm, final, homework);
		streamsize prec = cout.precision();
		cout << "Twoje ocena kocowa to " << setprecision(3)
		     << final_grade << setprecision(prec) << endl;
	} catch (domain_error) {
		cout << endl << "Musisz wprowadzi oceny. Sprbuj jeszcze raz." << endl;
		return 1;
	}

	return 0;
}

