#include <stdexcept>
#include <vector>
#include "grade.h"
#include "median.h"
#include "Student_info.h"

using std::domain_error;  using std::vector;


// oblicz ocen kocow studenta na podstawie oceny rdsemestralnej
// i oceny egzaminu kocowego oraz oceny pracy domowych
double grade(double midterm, double final, double homework)
{
	return 0.2 * midterm + 0.4 * final + 0.4 * homework;
}

// oblicz ocen kocow studenta na podstawie oceny rdsemestralnej i oceny egzaminu kocowego
// oraz wektora ocen prac domowych.
// funkcja ie kopiuje argumentu wywoania, poniewa kopiowanie odbywa si w funkcji `median'.
double grade(double midterm, double final, const vector<double>& hw)
{
	if (hw.size() == 0)
		throw domain_error("student nie odrobi prac domowych");
	return grade(midterm, final, median(hw));
}

double grade(const Student_info& s)
{
	return grade(s.midterm, s.final, s.homework);
}

