#ifndef _RANGEINT_H
#define _RANGEINT_H

#include <ostream.h>

class TRangeInt {
   public:
      static const int eLow = 0; // integralna staa klasy
      static const int eHigh = 255;
      // Utwrz obiekt typu TRangeInt z podanymi ograniczeniami i wartoci.
      TRangeInt (int vlow, int vhigh, int val);
      // Utwrz obiekt typu TRangeInt z domylnymi ograniczeniami i podan wartoci.
      TRangeInt (int val=0);
      ~TRangeInt() {};
      // Jak warto zawiera obiekt?
      int GetValue() const { return _value; };
      // Metody do odczytywania wartoci ogranicze.
      int Low() const { return _low; }
      int High() const { return _high; }
      // Wydrukuj w postaci (lowD, value, highG).
      ostream& StreamOut(ostream& stream) const {      // (1)
         stream << '(' << _low << "D, " << _value << ", " << _high << "G)";
         return stream;
      }
      istream& StreamIn(istream& stream); // odczytaj dane wejciowe z strumienia
      // pozostae metody pominito
   private:
      int _value; // waciwa warto cakowita
      int _low;
      int _high;  // granice zakresu
};

// Deklaracje funkcji operatorw pobierania i wstawiania.
istream& operator>>(istream& is, TRangeInt& ri);
ostream& operator<<(ostream& theStream, const TRangeInt& ri);

#endif
