#include "String.h"

TString:: TString()
{
   _str = 0;
   _length = 0;
}
TString:: TString(const char* arg)
{
   if (arg && *arg) { // wskanik nie jest 0 i
      // wskazuje na poprawne znaki
      _length = strlen(arg);
      _str = new char[_length + 1];
      strcpy(_str, arg);
   }
   else {
      _str = 0;
      _length = 0;
   }
}
TString:: TString(char aChar)
{
   if (aChar) {
      _str = new char[2];
      _str[0] = aChar;
      _str[1] = '\0';
      _length = 1;
   }
   else {
      _str = 0; _length = 0;
   }
}
TString::~ TString() { if (_str != 0) delete [] _str; }
// Konstruktor kopiujcy. Wykonuje gbok kopi. Alokuje pami 
// dla znakw i kopiuje do niej znaki. 
TString:: TString(const TString& arg)
{
   if (arg._str != 0) {
      this->_str = new char[strlen(arg._str) + 1];
      strcpy(this->_str, arg._str);
      _length = arg._length;
   }
   else {
      _str = 0; _length = 0;
   }
}
TString& TString::operator=(const TString& arg)
{
   if (this == &arg)
      return *this;
   if (this->_length >= arg._length) {
      // *this jest wystarczajco due
      if (arg._str != 0)
         strcpy(this->_str, arg._str);
      else
         this->_str = 0;
      this->_length = arg._length;
      return *this;
   }
   // jeli _arg jest wiksze, to miejsca jest za mao
   delete [] _str; // Bezpieczne
   this->_length = arg.Size();
   if (_length) {
      _str = new char[_length + 1];
      strcpy(_str, arg._str);
   }
   else _str = 0;
   return *this; // Zawsze wykonywane
}
TString& TString::operator=(const char* s)
{
   if ( s == 0 || *s == 0) {
      // tablica rdowa jest pusta. This te staje si puste.
      delete [] _str;
      _length = 0; _str = 0;
      
      return *this;
   }
   int slength = strlen(s);
   if (this->_length >= slength) {
      // *this jest wystarczajco due
      strcpy(this->_str, s);
      this->_length = slength;
      return *this;
   }
   // *this nie pomieci znakw, poniewa _arg jest wiksze
   delete [] _str; // bezpieczne
   this->_length = slength;
   _str = new char[_length + 1];
   strcpy(_str, s);

   return *this;
}
TString& TString::operator=(char charToAssign)
{
   char s[2];
   s[0] = charToAssign;
   s[1] = '\0';
   // Uywa innego operatora przypisania
   return (*this = s);
}
int TString::Size() const { return _length; }

TString& TString::operator+=(const TString& arg)
{
   if (arg.Size()) { // funkcje skadowe mog wywoywa si nawzajem
      _length = arg.Size() + this->Size();
      char *newstr = new char[_length + 1];
   if (this->Size()) // jeli orygina nie jest wskanikiem NULL
      strcpy(newstr, _str);
   else
      *newstr = '\0';
   strcat(newstr, arg._str); // dodaje argument
   delete [] _str; // zwalnia pami oryginau
   _str = newstr; // To nowy acuch znakw
   }
   return *this;;
}

TString operator+(const TString& first, const TString& second)
{
   TString result = first;
   result += second; // Wywouje funkcj skadow operator+=
   return result;
}

int
operator==(const TString& first, const TString& second)
{
   const char* fp = first.c_str(); // wywouje funkcj skadow
   const char* sp = second.c_str(); 
   if (fp == 0 && sp == 0) return 1;
   if (fp == 0 && sp) return -1;
   if (fp && sp == 0) return 1;
   return ( strcmp(fp, sp) == 0 ); // strcmp to funkcja biblioteczna
}

int
operator!=(const TString& first, const TString& second)
   { return !(first == second); } // powtrne uycie operatora ==
// Inne operatory porwnania zaimplementowane s tak jak operator==
// Nie umieszczono ich tutaj w celu zwikszenia przejrzystoci kodu

char TString::operator()(unsigned n) const
{
   if (n < this->Size())
      return this->_str[n]; // Zwraca znak na pozycji n
   return 0;
}

const char& TString::operator[](unsigned n) const
{
   if (n < this->Size())
      return this->_str[n]; // Zwraca znak na pozycji n
   cout << "Niepoprawny indeks: " << n << endl;
   exit(-1); // W tym miejscu powinno si zgasza wyjtek
   return _str[0]; // Tylko po to, aby kompilator nie zgasza zastrzee. 
      // Ten wiersz nigdy si nie wykonuje
}

// Zmienia wszystkie znaki na mae litery
TString& TString::ToLower()
{
   // Uywa funkcji bibliotecznej tolower
   if (_str && *_str) {
      char *p = _str;
      while (*p) {
         *p = tolower(*p);
         ++p;
      }
   }
   return *this;
}

TString& TString::ToUpper() // wiczenie dla czytelnika
{
   return *this;
}

TString TString::operator()(unsigned posn, unsigned len) const
{
   int sz = Size(); // rozmiar rda
   if (posn > sz) return ""; // Pusty acuch
   if (posn + len > sz)   len = sz - posn;
   TString result;
   if (len) {
      result._str = new char[len + 1];
      strncpy(result._str, _str + posn, len);
      result._length = len;
      result._str[len] = '\0';
   }
   return result;
}

ostream& operator<<(ostream& o, const TString& s)
{
   if (s.c_str())
      o << s.c_str();
   return o;
}

istream& operator >>(istream& stream, TString& s)
{
   char c;
   s = "";
   while (stream.get(c) && isspace(c));
      // nie robi nic
   if (stream) { // strumie jest wci poprawny
      // czyta znaki, a napotka znak spacji
      do {
      s += c;
      }   while ( stream.get(c) && !isspace(c));
      if (stream) // zwraca nadmiarowy znak
         stream.putback(c);
   }
  return stream;
}

