#include <iostream>
#include "Student.h"

// Tablica nazw wydziaw uatwia wywietlanie. Jeli wywietla si bezporednio
// wyliczenie, wtedy pojawiaj si tylko liczby cakowite, a oczekiwane s nazwy
// wydziaw. Do tego suy tablica acuchw. Wystarczy poindeksowa tablic elementami 
// wyliczenia EDepartment, aby otrzyma poprawne nazwy. Uywanie nieokrelonej
// przestrzeni nazw jest zgodne ze standardami jzyka C++.
namespace {

// Podobne rozumowanie dotyczy take tej tablicy. Suy ona do wywietlania
// statusu studenta w postaci nazwy. Kiedy poindeksuje si tablic elementami 
// wyliczenia EStudentStatus, otrzyma si poprawne nazwy.
   const char *statusLabels[] = { "Dzienne", "Wieczorowe", 
   "Wymiana", "Nieznane" };
}

TStudent::TStudent(const char theName[], unsigned long thePESEL,
   const char theBirthDate[], const char theAddress[],
   EStudentStatus theStatus, EDepartment theDepartment)
   // Najpierw inicjalizuje si obiekt klasy bazowej
      : TPerson(theName, thePESEL, theBirthDate, theAddress),
     _status(theStatus),
     _department(theDepartment),
     _numCourses(0)
{
   // Teraz nastpuje inicjalizacja dla pozostaej czci klasy
   // Lista kursw jest pusta
   for(int i = 0; i < MAX_COURSES_FOR_STUDENT; i++)
      _enrolled[i] = 0;
}

// Konstruktor kopiujcy
TStudent::TStudent(const TStudent& copy)
   : TPerson(copy), // wywouje konstruktor kopiujcy klasy bazowej
     _status(copy._status),
     _department(copy._department),
     _numCourses(copy._numCourses)
{
   // Kopiuje kursy
   for(int i = 0; i < MAX_COURSES_FOR_STUDENT; i++) {
      if (copy._enrolled[i] != 0)
         this->_enrolled[i] = new TCourse(*copy._enrolled[i]);
   }
}

// Operator przypisania
TStudent& TStudent::operator=(const TStudent& other)
{
   if (this == &other) return *this;
   // Wywouje operator przypisania klasy bazowej
   TPerson::operator=(other);

   this->_status = other._status;
   this->_department = other._department;
   this->_numCourses = other._numCourses;

   // Kopiuje kursy
   for(int i = 0; i < MAX_COURSES_FOR_STUDENT; i++) {
      if (this->_enrolled[i] != 0 && other._enrolled[i] == 0) {
         // Usuwa obiekt TCourse
         delete _enrolled[i];
      }
      else if (this->_enrolled[i] == 0 && other._enrolled[i] != 0) {
         this->_enrolled[i] = new TCourse(*(other._enrolled[i]));
      }
      else if (this->_enrolled[i] != 0 && other._enrolled[i] != 0) {
         *(this->_enrolled[i]) = *(other._enrolled[i]);
      }
   }
   return *this;
}

TStudent::~TStudent()
{
   for(int i = 0; i < MAX_COURSES_FOR_STUDENT; i++) {
      if (this ->_enrolled[i] != 0) {
         delete _enrolled[i];
      }
   }
}

void 
TStudent::Print() const
{
   cout << "Nazwisko i imi: " << TPerson::GetName() << endl;
   cout << "Adres: " << TPerson::GetAddress() << endl;
   cout << "Rodzaj studiw: " << statusLabels[(int)_status] << endl; 
   cout << "Wydzia: " << departmentNames[(int)_department] << endl;
}

