#ifndef _TGARAGE_H_
#define _TGARAGE_H_

class TAutomobile;
typedef unsigned int SlotNumber;

class TGarage {
  public:
    // Tworzy nowy gara z okrelon z gry pojemnoci (_capacity):
    TGarage (unsigned int howMany_slots);
    // Parkuje pojazd thisOne i zwraca numer stanowiska parkingowego:
    SlotNumber Park(TAutomobile* parkVehicle);
    // Zwalnia pojazd zaparkowany na stanowisku which,
    // zwraca wskanik zwolnionego pojazdu. Jeli numer stanowiska jest niepoprawny,
    // zwraca wskanik pusty:
    TAutomobile* ReleaseVehicle(SlotNumber which);
    // Pokazuje list wszystkich pojazdw zaparkowanych 
    void ListVehiclesParked() const;
    ~TGarage ();

  private:
    TGarage(const TGarage &);
    TGarage& operator=(const TGarage &);
    TAutomobile**       _slots;
    unsigned int        _capacity;
    unsigned int        _freeSlots;
};

#endif