// Program testowy
#include <iostream.h>
#include "CountedPointer.h"

class TExample {
   public:
      ~TExample() { cout << "Destruktor obiektu TExample(" << _id << ")\n"; }
      TExample(int i) : _id(i) {}
      void Print() const 
         { cout << "Wywietl obiekt TExample(" << _id << ")" << endl; }
   private:
      int _id;
};

template class TCountedPointer<TExample>;

main()
{
   // Utwrz obiekt dynamiczny klasy TExample o identyfikatorze = 1.
   TExample * px = new TExample (1);
   // Utwrz dla px obiekt klasy TCountedPointer.
   TCountedPointer<TExample> ap(px);
   // Utwrz kopi obiektu ap klasy TCountedPointer. Wykorzystywany jest konstruktor kopiujcy.
   TCountedPointer<TExample> bp=ap;
   // Utwrz niezwizany obiekt klasy TCountedPointer.
   TCountedPointer<TExample> cp;
   // Patrz rysunek 9.11.
   // Nastpny wiersz nie kompiluje si! Patrz wyjanienie poniej.
   // TCountedPointer<const TExample> constp;

   cout << "Liczba odwoa do obiektu ap (musi by rwna 2): " <<
   ap.GetReferenceCount() << endl;

   cout << "Przypisz ap do cp...\n";
   cp = ap;
   // Patrz rysunek 9.12.
   cout << "Liczba odwoa do obiektu ap (musi by rwna 3): " <<
   ap.GetReferenceCount() << endl;

   TExample * qx = new TExample (100);
   TCountedPointer<TExample> dp(qx);

   ap = dp; // zmniejsza liczb odwoa poprzez obiekt ap

   cout << "Odwoania do obiektu px (powinny by 2): " <<
   bp.GetReferenceCount() << endl;

   cout << "Odwoania do obiektu qx (powinny by 2): " <<
   dp.GetReferenceCount() << endl;

   dp->Print();
   (*cp).Print();

   // Ta instrukcja powoduje bd kompilacji - patrz niej.
   // constp = cp;

}

