
template <class AType, unsigned int Size> class TSafeArray {
   public:
      enum ESortOrder { eAscending, eDescending };
      TSafeArray();
      TSafeArray(const TSafeArray<AType, Size>& copy);
      TSafeArray<AType, Size>&
         operator=(const TSafeArray<AType, Size>& assign);
      virtual ~TSafeArray() { }
      unsigned int GetSize() const { return _arraySize; }
      virtual AType& operator[](int index);
      void Sort(ESortOrder order = eAscending);
      // ...
   private:
      int _arraySize;
      AType _ip[Size]; // tablica statyczna - rozmiar ustalony podczas kompilacji
};

// Implementacja niektrych funkcji skadowych.
// Pozostae funkcje skadowe pozostawiono jako wiczenie dla czytelnika.

template <class AType, unsigned int Size>
TSafeArray<AType, Size>::TSafeArray() : _arraySize(Size) {}

template <class AType, unsigned int Size>
AType& TSafeArray<AType, Size>::operator[](int index)
{
   if (index >= 0 && index < _arraySize) return _ip[index];
   else { /* Zgo wyjatek! */ }
}

main()
{
   TSafeArray<int, 10> x, y; // tablica 10 elementw
   x[3] = 10; // wykorzystuje funkcj operator[]
   x[4] = x[3];
   for(int i=0; i < 10; i++)
      x[i] = i;
}

