#include <iostream>

template <class AType>
void
Exchange(AType& x, AType& y)
{
   AType temp = x;
   x = y;
   y = temp;
}

template <class AType>
void
Sort(AType array[], int nitems)
{
   // Algorytm sortowania przyrostowego (algorytm Shella).
   // Z ksiki autorstwa Kernighana i Ritchie'ego - The C Programming Language
   // Sortowanie w porzdku rosncym.
   for (int gap = nitems/2; gap > 0; gap/=2) {
      for (int i = gap; i < nitems; i++) {
         for (int j=i - gap;
               j >= 0 && array[j] > array[j+gap];
               j -= gap)
            Exchange(array[j], array[j+gap]);
      }
   }
}

template<>
void
Sort<char*> (char* stringArray[], int nItems)
{
   // Specjalna implementacja do sortowania tablicy wskanikw.
   // Zastosowano tu algorytm sortowania bbelkowego.
   for (int i = 0; i < nItems-1; i++) {
      for (int j = i+1; j < nItems; j++) {
         // strcmp jest funkcj biblioteczn, ktra porwnuje leksykalnie dwa acuchy.
         // Zwraca warto 0, jeli acuchy s rwne, 1, jeli pierwszy acuch
         // jest wikszy od drugiego oraz -1, jeli to drugi acuch jest wikszy.
         // Porwnanie opiera si o wartoci kodu ASCII znakw.
         if ( strcmp(stringArray[i], stringArray[j]) > 0) {
            // zamie miejscami
            char* p = stringArray[i];
            stringArray[i] = stringArray[j];
            stringArray[j] = p;
         }
      }
   }
}

int
main()
{
   // Utwrz tablic wskanikw typu char.
   char* sa[] = { "bbbbbb", "AAAAAA", "111111", "ZZZZZZ" };
   Sort(sa, 4); // sprbuj posortowa tablic acuchw przy uyciu funkcji specjalizowanej
   for (int i = 0; i < 4; i++)
      cout << sa[i] << "\t";

   cout << "\nGotowe\n";

   return 0;
}

