#include <iostream>

template <class AType>
void
Exchange(AType& x, AType& y)
{
   AType temp = x;
   x = y;
   y = temp;
}

template <class AType>
void
Sort(AType array[], int nitems)
{
   // Algorytm sortowania przyrostowego (algorytm Shella).
   // Z ksiki autorstwa Kernighana i Ritchie'ego - The C Programming Language
   // Sortowanie w porzdku rosncym.
   for (int gap = nitems/2; gap > 0; gap/=2) {
      for (int i = gap; i < nitems; i++) {
         for (int j=i - gap;
               j >= 0 && array[j] > array[j+gap];
               j -= gap)
            Exchange(array[j], array[j+gap]);
      }
   }
}

main()
{
   int ia[] = {22, 1, 3, 9, 4, 0, 11};
   Sort(ia, 7); // sprbuj posortowa tablic ia
   for (int i = 0; i < 7; i++)
      cout << ia[i] << "\t"; // wydrukuj tablic
}

