#include <iostream.h>
// Wskanik ze zliczaniem odwoa wykorzystujcy przecione funkcje operator->
// oraz operator*. Ta implementacja NIE jest bezpieczna z punktu widzenia kodu
// wielowtkowego. Aby tak byo, definicja typedef ReferenceCount musiaaby by
// oddzieln klas.
// OSTRZEENIE: Tej klasy mona uywa wycznie z obiektami alokowanymi na stercie.
// Nie powinno si jej uywa w przypadku obiektw tworzonych na stosie.

// Trzeba zastpi klas, jeli wymagane jest bezpieczestwo wtkw.
typedef unsigned long ReferenceCount;

template <class AType>
class TCountedPointer
{
   public:
      TCountedPointer(); // konstruktor domylny
      // Parametr adoptTarget musi wskazywa na zasb alokowany za pomoc operatora new.
      // Zostanie on usunity, kiedy zniknie obiekt wskanika.
      TCountedPointer(AType* adoptTarget);
      TCountedPointer(const TCountedPointer<AType>& copy);
      virtual ~TCountedPointer();
      TCountedPointer<AType>& operator=(const TCountedPointer<AType>& assign);

      // Zwraca warto true, jeli obiekt jest wskanikiem do niezerowego obszaru.
      bool IsValid() const;

      bool operator==(const TCountedPointer<AType>& other) const;
      bool operator!=(const TCountedPointer<AType>& other) const;

      AType& operator*() const;

      AType* operator->() const;

      // Wycznie dla celw testowania.
      int GetReferenceCount() const;

   protected:
      void AddReference();
      void RemoveReference();

   private:
      ReferenceCount* _refCount;
      AType* _targetPointer;
};

template <class AType>
TCountedPointer<AType>::TCountedPointer() : _refCount(0), _targetPointer(0)
   { }

template <class AType>
TCountedPointer<AType>::TCountedPointer(AType* adoptTarget) : _refCount(0),
   _targetPointer(adoptTarget)
   { AddReference(); /* inkrementuj licznik odwoa */ }

template <class AType>
TCountedPointer<AType>::TCountedPointer(const TCountedPointer<AType>& copy) :
   _refCount(copy._refCount), _targetPointer(copy._targetPointer)
   { AddReference(); } // dodaj jeszcze jedno odwoanie

template <class AType>
TCountedPointer<AType>::~TCountedPointer() { RemoveReference(); }

template <class AType>
TCountedPointer<AType>&
TCountedPointer<AType>::operator=(const TCountedPointer<AType>& that)
{
   if (this != &that) {
      RemoveReference(); // obiekt po lewej stronie traci odwoanie
      this->_targetPointer = that._targetPointer;
      this->_refCount = that._refCount;
      AddReference(); // obiekt po prawej stronie zyskuje odwoanie
   }

   return *this;
}

template <class AType>
bool
TCountedPointer<AType>::IsValid() const { return (_targetPointer != 0); }

template <class AType>
bool
TCountedPointer<AType>::operator==(const TCountedPointer<AType>& other) const
{ return (_targetPointer == other._targetPointer); }

template <class AType>
bool
TCountedPointer<AType>::operator!=(const TCountedPointer<AType>& other) const
{ return !operator==(other); }

template <class AType>
AType&
TCountedPointer<AType>::operator*() const { return *_targetPointer; }

template <class AType>
AType*
TCountedPointer<AType>::operator->() const { return _targetPointer; }

// To jest funkcja wspomagajca testowanie.
template <class AType>
int
TCountedPointer<AType>::GetReferenceCount() const
{
   if (_refCount) return *_refCount;
   else return -1;
}

template <class AType>
void
TCountedPointer<AType>::AddReference()
{
   if (_refCount) (*_refCount)++;
   else {
      _refCount = new ReferenceCount;
      *_refCount = 1;
   }
}

template <class AType>
void
TCountedPointer<AType>::RemoveReference()
{
   if (_refCount) { // dekrementuj licznik odwoa i usu obiekt waciwy
      (*_refCount)--;
      if (*_refCount == 0) { // usu obiekt waciwy
         delete _refCount;
         delete _targetPointer;
         _refCount = 0;
         _targetPointer = 0;
      }
   }
}

