#ifndef _TEACHER_H
#define _TEACHER_H

#include "Person.h"
#include "Course.h"

// Klasa potrzebuje wyliczenia EDepartment, ktrego deklaracja znajduje si w pliku Student.h   
// Kady wykadowca posiada stopie. Znajduj si one w tym wyliczeniu
enum ERank { eInstructor, eGraduateTeachingAssistant, eAsstProfessor,
   eAssociateProfessor, eProfessor, eDean };

// Maksymalna liczba kursw, ktre moe prowadzi wykadowca
const short MAX_COURSES_FOR_TEACHER = 3;
const short MAX_GRADERS = 5;

class TTeacher : virtual public TPerson {
   public:
      TTeacher (const char theName[], unsigned long thePESEL, 
         const char theBirthDate[], const char theAddress[],
         ERank theRank, EDepartment theDepartment);
      TTeacher(const TTeacher& other);
      TTeacher& operator=(const TTeacher& other);
      ~TTeacher();

      void SetDepartment(EDepartment dept);
      EDepartment GetDepartment() const;

      // Zmienia stopie przy awansie wykadowcy
      void SetRank(ERank newRank);
      ERank GetRank() const;
   
      void ListCoursesTaught() const;
      // Proponuje ten kurs
      bool OfferCourse(const TCourse& aCourse);
      // Anuluje kurs
      bool DropCourse(const TCourse& theCourse);

      void AssignGrader(const char newGrader[]);
      void DropGrader(const char grader[]);
      void ListGraders() const;

      /* Te funkcje nie powinny znajdowa si w tym miejscu. Nie kady klient
         powinien mie dostp do danych osobowych. Lepsze rozwizanie 
         znajduje si w dalszych rozdziaach. */
      double GetSalary() const;
      bool SetSalary(double theSalary);
      void SetSupervisor(const char theName[]);

      void Print() const;

   private:
      // Szczegy implementacji znajduj si tu tylko w celu uzupenienia przykadu.
      // Nie s potrzebne do zrozumienia omawianych zagadnie.
      ERank        _rank;
      double       _salary;
      EDepartment  _department;
      TString      _supervisor;
      int          _numCourses; // Liczba kursw, na ktrych wykada
   
      // Tablica wskanikw do kursw, na ktrych wykada. Bardzo podobna do tej, 
      // ktra znajduje si w klasie TStudent.
      TCourse*     _coursesOffered[MAX_COURSES_FOR_TEACHER];
      // Lista magistrantw w postaci tablicy wskanikw do ich nazwisk
      TString*     _graders[MAX_GRADERS];
};

#endif
