#ifndef _PERSON_H
#define _PERSON_H

#include "String.h"

enum EDepartment { eAccounting, eBusiness, eEngineering, eMathematics, 
   ePhysics, eChemistry, eArts, eUnknown /* i inne */ };

namespace {   
      const char *departmentNames[] = { "Rachunkowo", "Biznes", 
     "Inynieria", "Matematyka", "Fizyka", "Chemia", 
     "Sztuka", "Nieznany" };
     }

class TPerson {
   public:
      TPerson();
      TPerson (const char theName[], unsigned long thePESEL,
         const char theBirthDate[], const char theAddress[]);
      TPerson (char* theBirthDate); 
      // Konstruktor kopiujcy
      TPerson (const TPerson& source);
      TPerson& operator=(const TPerson& source);
      ~TPerson();
   
      void SetName(const char theName[]);
      TString GetName() const;
      void SetAddress(const char theAddress[]);
      TString GetAddress() const;
      TString GetBirthDate() const;
      unsigned long GetIdentification() const;
      void SetIdentification(unsigned long newId);
      
      
      bool operator ==(const TPerson& other) const;
      bool operator !=(const TPerson& other) const;

      virtual void Print() const;

   private:
      TString _name;
      TString _address;
      unsigned long _pesel;
      const char* _birthDate;
};

#endif
