#include <iostream>
#include "Person.h"

using namespace std;

TPerson::TPerson (const char theName[], unsigned long thePESEL,
   const char theBirthDate[], const char theAddress[])
   : _name(theName), _address(theAddress),
     _birthDate(theBirthDate), _pesel(thePESEL)
   { }

TPerson::TPerson(const TPerson& other)
   : _birthDate(other._birthDate), _name(other._name),
     _address(other._address), _pesel(other._pesel)
   {}
   
TPerson::TPerson (char* theBirthDate) :
   _pesel(0), 
   _name(""), 
   _birthDate(theBirthDate), 
   _address("")
   { /* puste ciao konstruktora */ }

TPerson::TPerson ()
{
   // konstruktor uywa przypisania, co nie jest najlepszym rozwizaniem,
   // ale i tak lepszym, ni brak kodu
   _name = "";
   _address = "";
   _pesel = 0; 
   _birthDate = "";
}

void
TPerson::SetName(const char theName[])
   { _name = theName; /* To jest proste. Za reszt odpowiada klasa TString */ }

void 
TPerson::SetAddress(const char theAddress[])
   { _address = theAddress; /* Take za to odpowiada klasa TString */ }

TString 
TPerson::GetName() const
{
   return _name;
}

TString
TPerson::GetAddress() const
{
   return _address;
}

void 
TPerson::Print() const
{
   cout << " - Wywietla szczegowe dane o osobie - " << endl;
   cout << "Imi i nazwisko: " << _name << endl;
   cout << "Adres: " << _address << endl;
   cout << "Data urodzenia: " << _birthDate << endl;
}

TPerson::~TPerson()
{ /* Nic nie robi. Za zarzdzanie pamici odpowiadaj obiekty osadzone. */ }



TPerson& TPerson::operator=(const TPerson& other)
{
   _birthDate = other._birthDate,
   _name = other._name;
   _address = other._address;
   _pesel = other._pesel;
}

bool
TPerson::operator==(const TPerson& other) const
{
   if (this == &other) { return true; } // porwnuje ten sam obiekt o innych nazwach
   if (this->_pesel == other._pesel && this->_birthDate ==
      other._birthDate) {
      // Teraz porwnuje imi i nazwisko
   //   if (strcmp(this->_name, other._name) == 0)
         // strcmp to funkcja biblioteczna
         return true;
   }
   return false; // nie s rwne
}

bool
TPerson::operator != (const TPerson& other) const
{
   return ! (*this == other); // mona te napisa:
   // return ! (this->operator==(other));
}


