#ifndef _GRADUATESTUDENT_H
#define _GRADUATESTUDENT_H

#include "Student.h"
#include "Teacher.h"

using namespace std;

// Liczba kursw, na ktre doktorant moe si zapisa w cigu semestru
const unsigned MAX_COURSES_FOR_GRAD_STUDENT = 5;
// Ogranicza liczb kursw. Doktorant nie moe zapisywa
// si na kursy poniej tego poziomu.

const unsigned GRAD_COURSE_LEVEL = 400;
class TGraduateStudent : public TStudent {
   public:
      TGraduateStudent (const char theName[],
      unsigned long thePESEL, // doktoranta
      const char theBirthDate[], 
      const char theAddress[],
      EStudentStatus theStatus,
      EDepartment theDepartment,
      const TTeacher& advisorInCharge);

// Konstruktor kopiujcy
      TGraduateStudent(const TGraduateStudent& source);
      TGraduateStudent& operator=(const TGraduateStudent& source);
      ~TGraduateStudent();
// T metod trzeba przesoni, poniewa doktorant moe
// zapisywa si jedynie na okrelone kursy, podczas gdy
// student moe zapisywa si na wszystkie kursy.
      bool EnrollForCourse(const TCourse& aCourse);
      void ChangeAdvisor(const TTeacher& newAdvisor);
      TTeacher GetAdvisor() const;
// Ta metoda wywietla istotne informacje o doktorancie
      virtual void Print() const;
// Wszystkie inne metody dziedziczone s bez zmian, 
// poniewa klasa TGraduateStudent nie rni si w 
// w tych miejscach od klasy TStudent - chodzi tu o
// imi i nazwisko, adres, wykrelanie z kursw itd.
// Taka jest sia dziedziczenia.
   private:
// Doradca dla tego doktoranta
      TTeacher _advisor;
// Liczba kursw, ktre wybra doktorant
      unsigned short _numCourses;
};

#endif
