#include <iostream>
#include "GraduateStudent.h"

/*
Wszystkie argumenty klasy TGraduateStudent s takie same jak w klasie TStudent,
za wyjtkiem argumentu advisorInCharge. Dlatego wystarczy wywoa konstruktor
klasy bazowej TStudent, a nastpnie zainicjalizowa obiekt advisor za pomoc
konstruktora kopiujcego klasy TTeacher. W ten sposb otrzymuje si gotowy obiekt
TTeacher, za pomoc ktrego mona utworzy nowy obiekt TTeacher w klasie 
TGraduateStudent. Takie rozwizanie stosuje si tworzc nowy obiekt z obiektu
istniejcego. Konstruktor kopiujcy klasy TTeacher wydaje si by stworzony do
tego typu operacji. 
*/

namespace {

   const char *statusLabels[] = { "Dzienne", "Wieczorowe", 
   "Wymiana", "Nieznane" };
}

TGraduateStudent::TGraduateStudent(const char theName[],
   unsigned long thePESEL, 
   const char theBirthDate[],
   const char theAddress[],
   EStudentStatus theStatus,
   EDepartment theDepartment,
   const TTeacher& advisorInCharge)
// Najpierw inicjalizuje obiekt klasy bazowej
   : TStudent(theName, thePESEL, theBirthDate, theAddress,
      theStatus, theDepartment),
// Nastpnie za pomoc konstruktora kopiujcego klasy TTeacher
// inicjalizuje obiekt advisor
   _advisor(advisorInCharge),
   // Inicjalizacja wirtualnej klasy bazowej
   TPerson(theName, thePESEL, theBirthDate, theAddress)

{
// Teraz mona ustawi potrzebne dane czci TGraduateStudent
   _numCourses = 0;
}
// Zwyky kod klasy
// Konstruktor kopiujcy
TGraduateStudent::TGraduateStudent(const TGraduateStudent& other)
   : TStudent(other), // Wywouje konstruktor kopiujcy klasy bazowej
   _advisor(other._advisor),
   _numCourses(other._numCourses)
{
   // Nic nie trzeba robi
}

// Operator przypisania
TGraduateStudent&
TGraduateStudent::operator=(const TGraduateStudent& other)
{
// Sprawdza przypisanie do siebie
   if (this == &other)
      return *this;
// Wywouje operator przypisania klasy bazowej
   TStudent::operator=(other);

   this->_advisor = other._advisor;
   this->_numCourses = other._numCourses;

   return *this;
}

TGraduateStudent::~TGraduateStudent()
{
// Nic nie trzeba robi
}

// Wikszo wywietlanych informacji znajduje si w klasie TStudent.
// Naley pobra te informacje z klasy TStudent i wywietli je w
// odpowiedniej kolejnoci. Dodatkowo wywietla si imi i nazwisko doradcy.
void
TGraduateStudent::Print() const
{
   cout << "Imi i nazwisko: " << TStudent::GetName() << endl;
   cout << "Adres: " << TStudent::GetAddress() << endl;
   EStudentStatus status = GetStatus();
   EDepartment dept = GetDepartment();
   cout << "Rodzaj studiw doktoranckich: " << 
      statusLabels[(int)status] << endl;
   cout << "Wydzia: " << departmentNames[(int)dept] << endl;
   cout << "Doradca: " << _advisor.GetName() << endl;
}

bool
TGraduateStudent::EnrollForCourse(const TCourse& aCourse)
{
// Sprawdza, czy doktorant nie przekroczy limitu kursw
   if (_numCourses >= MAX_COURSES_FOR_GRAD_STUDENT) {
      cout << "Doktorant nie moe zapisa si na wicej ni " <<
      MAX_COURSES_FOR_GRAD_STUDENT << " kursw." << endl;
      return false;
   }

// Sprawdza, czy poziom kursu nie jest niszy od GRAD_COURSE_LEVEL
   if (aCourse.GetCourseId() < GRAD_COURSE_LEVEL) {
      cout << "Niestety doktoranci nie mog zapisywa si na kursy poniej " 
      << GRAD_COURSE_LEVEL << " poziomu." << endl;
      return false;
   }

// W przeciwnym przypadku klasa bazowa TStudent wykonuje wszystkie operacje potrzebne
// do zapisania doktoranta na kurs. Jeli si to powiedzie, wtedy zwiksza
// si liczba kursw.
   bool result = TStudent::EnrollForCourse(aCourse);
   if (result == true)
      _numCourses++;
   return result;
}
// Zwraca przez warto obiekt advisor klasy TTeacher
TTeacher
TGraduateStudent::GetAdvisor() const
{
   return _advisor;
}

// Przypisuje obiekt newAdvisor do istniejcego obiektu advisor
void
TGraduateStudent::ChangeAdvisor(const TTeacher& newAdvisor)
{
   _advisor = newAdvisor;
}

