#include <vector>
#include <iostream>
#include <iterator>

using namespace std;

template <class ForwardIterator, class BackwardIterator>
bool SearchForPalindrome(ForwardIterator first, BackwardIterator last)
{
    int n = 0;
    // Funkcja distance zwiksza n o liczb krokw potrzebnych na przejcie
    // od elementu first do elementu last:
    distance(first, last, n);
    n /= 2;
    while (n--)
        if (*first++ != *last--)    // brak palindromu!
            return false;

    return true;    // mamy palindrom!
}


main()
{
    vector<int> intVector(10);    //tworzenie wektora
    // Wypenianie kontenera intVector wartociami cakowitymi:
    for (int i = 0; i < 5; i++)
        intVector[i] = i;

    for (int i = 5; i < 10; i++)  // to samo od koca
        intVector[i] = 9 - i;

    vector<int>::iterator itr1 = intVector.begin();  // pobranie iteratora pierwszego elementu
    vector<int>::iterator itr2 = intVector.end();   // pobranie iteratora ostatniego elementu

    if (SearchForPalindrome(itr1, --itr2))  // to powinno si uda
        cout << "TAK, TO PALINDROM" << endl;

    --itr2;    // cofnicie iteratora o jeden element
    if (SearchForPalindrome(++itr1, --itr2))  // tym razem poraka
        cout << "TO NIE JEST PALINDROM" << endl;
}

