class TInt {
   public:
      // Konstruktor - tworzy obiekt TInt za pomoc liczby cakowitej
      TInt(int value);
      TInt(long mostSignificant, unsigned long leastSignificant);
      // Tworzy obiekt TInt za pomoc dugiej liczby cakowitej
      TInt(long value);
      // Tworzy obiekt TInt z krtkiej liczby cakowitej
      TInt(short value);
      // Konstruktor domylny
      TInt();

      // Konstruktor kopiujcy
      TInt(const TInt& copy);
      // Operator przypisania
      TInt& operator=(const TInt& assign);
      
      // Destruktor
      ~TInt();

      // Operatory dla typu TInt
      TInt   operator+(const TInt& operand) const;   // dodawanie
      TInt   operator-(const TInt& operand) const;   // odejmowanie
      TInt   operator*(const TInt& multiplicand) const;   // mnoenie
      TInt   operator/(const TInt& divideBy) const;   // dzielenie
      TInt   operator%(const TInt& divideBy) const;   // dzielenie modulo
      // Dodawanie argumentu do liczby
      TInt   operator+=(const TInt& operand);
      // Dla uproszczenia ominito wiele innych operatorw

      // Podnosi liczb do potgi "to"
      TInt   Power(const TInt& to) const;
      void   Print() const;
      // Zwraca warto absolutn liczby
      TInt Absolute() const;
      // Zmienia znak liczby
      void FlipSign();

     // Funkcje pomocnicze
      long GetMostSignificantPart() const;
      unsigned long GetLeastSignificantPart() const;

   private:
      // Wewntrzna reprezentacja typu TInt
      unsigned long        _leastSignificantPart;
      long                 _mostSignificantPart;
      // i prawdopodobnie inne prywatne metody
};

