#include <ostream.h>
class TRangeInt {
   public:
      static const int eLow = 0;    // staa, ktra musi by zdefiniowana w pliku implementacji
      static const int eHigh = 255; // domylne grne ograniczenie
      // Utwrz obiekt typu TRangeInt z podanymi ograniczeniami i wartoci.
      TRangeInt (int vlow, int vhigh, int val);
      // Utwrz obiekt typu TRangeInt z domylnymi ograniczeniami i podan wartoci.
      TRangeInt (int val=0);
      // Jak warto zawiera obiekt?
      int GetValue() const { return _value; };
      // Metody do odczytywania wartoci ogranicze.
      int Low() const { return _low; }
      int High() const { return _high; }
      TRangeInt& operator+=( const TRangeInt& addThis);
      TRangeInt& operator++();           // jednoargumentowy przedrostkowy operator inkrementacji
      TRangeInt operator++(int notUsed); // jednoargumentowy przyrostkowy operator inkrementacji
      ostream& operator<<(ostream& stream) const {
         stream << '(' << _low << "D, " << _value << ", " << _high << "G)";
         return stream;
      }
      istream& operator>>(istream& stream);
      operator int() { return _value; }
   private:
      int _value; // waciwa warto cakowita
      int _low, _high;  // granice zakresu
};

// Operatory wstawiania i pobierania dla obiektw klasy TRangeInt.
ostream& operator<<(ostream& stream, const TRangeInt& printThis)
   { return printThis << stream; }
istream& operator>>(istream& stream, TRangeInt& object)
   { return (object >> stream); }

TRangeInt::TRangeInt(int vlow, int vhigh, int val) {
   _value=val;
   _high=vhigh;
   _low=vlow;
}

TRangeInt::TRangeInt(int val=0) {
   _value=val;
   _high=eHigh;
   _low=eLow;
}


// Wersja przedrostkowa operatora ++
TRangeInt& TRangeInt::operator++()
{
   // Sprawd, czy warto mieci si w zakresie,
   // a jeli tak, inkrementuj warto i zwr obiekt.

   if (_value < _high) { // warto mieci si w zakresie
      _value++;
      return *this;
   }
   else {
      // W tym przypadku naley zgosi wyjtek, poniewa nie mona
      // inkrementowa wartoci. Nie moemy ponadto zwrci adnego kodu bdu,
      // poniewa musimy zwrci obiekt. A zatem najlepszym rozwizaniem bdzie
      // zgoszenie wyjtku okrelajcego przyczyn niepowodzenia operacji.
      // Szczegowe informacje na temat wyjtkw znale mona w rozdziale 10.
   }
}

// Wersja przyrostkowa operatora ++
TRangeInt TRangeInt::operator++(int notUsed /* NIEUYWANY */)
{
   // Najpierw musimy zachowa biec warto obiektu *this, nastpnie modyfikujemy obiekt *this,
   // a na koniec zwracamy zachowan warto.

   TRangeInt temp(*this); // wykorzystujemy konstruktor kopiujcy
   // Sprawd, czy warto mieci si w zakresie,
   // a jeli tak, inkrementuj warto i zwr zachowany obiekt.

   if (_value < _high) { // warto mieci si w zakresie
      _value++;
      return temp; // zwr przez warto
   }
   else {
      // W tym przypadku naley zgosi wyjtek, poniewa nie mona
      // inkrementowa wartoci. Nie moemy ponadto zwrci adnego kodu bdu,
      // poniewa musimy zwrci obiekt. A zatem najlepszym rozwizaniem bdzie
      // zgoszenie wyjtku okrelajcego przyczyn niepowodzenia operacji.
   }
   /* Rozwizanie alternatywne: wykorzystanie implementacji wersji przedrostkowej
      TRangeInt temp(*this);
      ++(*this);
      return temp;
   */
}

TRangeInt&
TRangeInt::operator+=(const TRangeInt& addThis)
{
   /*
      Implementacja jest dosy prosta. Argument addThis zostaje dodany do obiektu
      reprezentowanego przez wskanik "this". W rzeczywistoci obiekt wskazywany
      przez "this" ju istnieje, a ponadto posiada ju dolne i grne ograniczenie
      swojej wartoci. Musimy wic jedynie doda warto addThis._value do danej
      skadowej this->_value zapewniajc jednoczenie, e wynik this->_value bdzie si
      nadal mieci w dopuszczalnym zakresie. Jeli operacja dodawania miaaby
      spowodowa przekroczenie przez dan skadow this->_value dolnego lub grnego
      ograniczenia, to dodawania nie wykonujemy.
   */
   if (addThis._value == 0) return *this; // nic nie trzeba robi

   if ( (addThis._value + this->_value) > this->_high ||
        (addThis._value + this->_value) < this->_low ) // jeli dodajemy warto ujemn
      return *this; // Operacja spowoduje przekroczenie zakresu.
                    // POWINNIMY waciwie w tym miejscu zgosi wyjtek.

   // OK, teraz moemy doda liczb, ktr zawiera obiekt addThis.
   this->_value += addThis._value;

   return *this; // zwr referencj do obiektu wystpujcego po lewej stronie operatora
}

TRangeInt
operator+(const TRangeInt& first, const TRangeInt& second)
{
   /*
   * Musimy utworzy nowy obiekt klasy TRangeInt do przechowywania wyniku. Klient nie
     nie moe utworzy takiego obiektu. Obiekt utworzony wewntrz tej funkcji 
     (na stosie) ulegnie zniszczeniu jak tylko j opucimy. Jeli za utworzymy
     obiekt dynamiczny (na stercie), to kto bdzie odpowiedzialny za jego zniszczenie?
     Ponadto obliczona suma musi zosta zwrcona do funkcji wywoujcej. A zatem wynik
     musi istnie poza zakresem tej funkcji. Jedynym sposobem, aby bezpiecznie tego
     dokona, jest skopiowanie wyniku poza t funkcj, tj. zwrcenie wyniku przez
     warto.

   * Jakie powinny by granice zakresu nowego obiektu? Czy naley wykorzysta te z
     pierwszego czy te z drugiego argumentu? A moe powinny by zupenie inne?
     Zgodnie z konserwatywnym podejciem ustawimy granice zakresu w obiekcie wynikowym
     na nisz grn i wysz doln granic z argumentw pierwszego i drugiego. Jeli
     wic pierwszy argument posiada zakres (10, 100), a drugi (5, 50). Mona by rwnie
     naoy ograniczenie, aby obydwa argumenty posiaday te same granice zakresu.
     My zapewniamy bardziej elastyczn implementacj. Czytelnik moe j oczywicie
     zmieni wedle wasnego upodobania.
   */

   int newLow, newHigh;
   // Grnym ograniczeniem nowej liczby bdzie nisze z obydwu operandw.
   // Do tej operacji mona rwnie uy funkcji bibliotecznej min .
   newHigh = (first.High() > second.High()) ? second.High() : first.High();
   // Dolnym ograniczeniem nowej liczby bdzie wysze z obydwu operandw.
   // Do tej operacji mona rwnie uy funkcji bibliotecznej max .
   newLow = (first.Low() > second.Low()) ? first.Low() : second.Low();

   int newValue = first.GetValue() + second.GetValue();
   if (newValue >= newLow && newValue <= newHigh) {
      // To jest prawidowa operacja. Utwrz lokalny obiekt klasy TRangeInt i zwr go.
      return TRangeInt( newLow, newHigh, newValue);
   }
   // ******************************** BD *****************************************
   // Co powinnimy zrobi, jeli suma wykracza poza dozwolony zakres?
   // Waciwym rozwizaniem byoby zgoszenie wyjtku sygnalizujcego niepowodzenie
   // operacji. Nie poznalimy jeszcze mechanizmu wyjtkw, wic zwrcimy po prostu
   // obiekt klasy TRangeInt o wszystkich wartociach rwnych zero.

   return TRangeInt(0, 0, 0);
}

TRangeInt
operator+(const TRangeInt& first, int  second)
{
   // Taka sama procedura jak przedstawiona powyej. Jedyna rnica polega na tym, e
   // granice zakresu s przejmowane z pierwszego argumentu.

   int newValue = first.GetValue() + second;
   if (newValue >= first.Low() && newValue <= first.High()) {
      // To jest prawidowa operacja +. Utwrz lokalny obiekt klasy TRangeInt
      // i zwr go.
      return TRangeInt( first.Low(), first.High(), newValue);
   }

   // ******************************** BD *****************************************
   // Co powinnimy zrobi, jeli suma wykracza poza dozwolony zakres?
   // Waciwym rozwizaniem byoby zgoszenie wyjtku sygnalizujcego niepowodzenie
   // operacji. Nie poznalimy jeszcze mechanizmu wyjtkw, wic zwrcimy po prostu
   // obiekt klasy TRangeInt o wszystkich wartociach rwnych zero.
   return TRangeInt(0, 0, 0);
}

inline
TRangeInt operator+(int first, const TRangeInt& second)
{
   // Zamie operandy miejscami i wykorzystaj poprzedni funkcj operator+.
   // Funkcja ta jest zdefiniowana jako inline, aby unikn dodatkowej koniecznoci wywoania funkcji.
   return (second + first);
}

istream& TRangeInt::operator>>(istream& is)
{
   int value = 0, low = eLow, high = eHigh;
   char c; // do odczytu ze strumienia

   is >> c; // odczytaj pierwszy znak
   if (c == '(') {
      // Uytkownik poda jedynie granice zakresu lub zarwno granice, jak i warto.
      // Musimy odczyta pozostae dane i sprawdzi, co zostao okrelone.
      is >> low >> c; // odczytaj (prawdopodobnie) doln granic oraz nastpny znak
      if (c == ',')
         is >> value >> c; // odczytaj warto (prawdopodobnie) oraz nastpny znak
      if (c == ')' ) {
         // Uytkownik poda jedynie granice zakresu, a nie warto obiektu klasy
         // TRangeInt.
         high = value;
         value = low; // ustaw warto na doln granic, poniewa nie wiemy,
                      // jaka ona powinna by
      }
      else if (c == ',') { // uytkownik poda wszystkie trzy wartoci
         is >> high >> c;
         if (c != ')') {
            // Bdny format danych wejciowych. Ustaw bdny stan strumienia.
            is.clear(ios::badbit);
         }
      }
   }
   else {
      // Uytkownik poda sam warto. Najpierw trzeba zwrci do strumienia
      // ostatni odczytany znak, poniewa jest on czci wartoci.
      is.putback(c);
      is >> value;
   }
   if (is) { // jeli strumie jest nadal w dobrym stanie (brak bdw)
      if (low >= high)
         return is; // mona by w tym miejscu zgosi wyjtek (szczegy w rozdziale 10)
      if (value >= low && value <= high)
         this->_value = value; // warto mieci si w granicach zakresu
      else return is; // bdne granice zakresu
      this->_low = low;
      this->_high = high;
   }
   return is;
}

