#include <iostream>
#include "Teacher.h"

namespace { // Uywa si nieokrelonej przestrzeni nazw
   const char *rankNames[] = { "Wykadowca", "Asystent",
      "Profesor", "Pracownik naukowy", "Dziekan", "Nieznany" };
}

TTeacher::TTeacher (const char theName[], unsigned long thePESEL, 
   const char theBirthDate[], const char theAddress[], 
   ERank theRank, EDepartment theDepartment)
   : TPerson(theName, thePESEL, theBirthDate, theAddress),
     _rank(theRank),
     _department(theDepartment),
     _salary(0.0), // Zarobki jeszcze nieznane
     _numCourses(0)
{
   // Na pocztku lista kursw jest pusta
   for (int i = 0; i < MAX_COURSES_FOR_TEACHER; i++)
      _coursesOffered[i] = 0;

   // Aby stan by poprawny, naley zainicjalizowa inne dane skadowe
   for(int i = 0; i < MAX_GRADERS; i++)
      _graders[i] = 0;
}

TTeacher::TTeacher(const TTeacher& other)
   : TPerson(other),
     _rank(other._rank),
     _department(other._department),
     _salary(other._salary), // Zarobki jeszcze nieznane
     _numCourses(other._numCourses)
{ 

}

TTeacher&
TTeacher::operator=(const TTeacher& other)
{
   if (this == &other) return *this;
      
   TPerson::operator=(other);   
   this->_rank = other._rank;
   this->_department = other._department;
   this->_salary = other._salary;
   this->_numCourses = other._numCourses;   
}
   

TTeacher::~TTeacher()
{ }

bool
TTeacher::OfferCourse(const TCourse& aCourse)
{
   if (_numCourses >= MAX_COURSES_FOR_TEACHER)
      return false; // Wykadowca zaproponowa ju zbyt wiele kursw
   /* Przechodzi przez tablic wskanikw coursesOffered i znajduje puste miejsce.
      Nastpnie alokuje nowy obiekt TCourse i umieszcza go w wolnym miejscu. Jeli 
      nie ma wolnych miejsc, oznacza to, e wykadowca zaproponowa ju
      maksymaln liczb kursw. */
   for (int i = 0; i < MAX_COURSES_FOR_TEACHER; i++) {
      if (_coursesOffered[i] == 0) {
         _coursesOffered[i] == new TCourse(aCourse); // wywouje konstruktor kopiujcy
         _numCourses++;
         return true;
      }
   }
   return false;
   // Wykadowca zaproponowa ju zbyt wiele kursw
}

bool
TTeacher::DropCourse(const TCourse& thisCourse)
{
   /* Szuka na licie kursw wykadowcy kursu z odpowiednim numerem identyfikacyjnym.
      Jeli znajduje, wykrela go z listy. Jeli nie znajduje, nic nie robi. */
   for (int i = 0; i < MAX_COURSES_FOR_TEACHER; i++) {
      if (_coursesOffered[i] != 0) {
         if (*_coursesOffered[i] == thisCourse) {
            delete _coursesOffered[i];
            _coursesOffered[i] = 0;
            _numCourses--;
            return true;
         }
      }
   }
   return false;
   // Wykadowca nie proponowa tego kursu.
}

void
TTeacher::SetDepartment(EDepartment dep)
{

}

EDepartment
TTeacher::GetDepartment() const
{
   return _department;
}

void 
TTeacher::Print() const
{
   cout << "Imi i nazwisko: " << TPerson::GetName() << endl;
   cout << "Adres: " << TPerson::GetAddress() << endl;
   cout << "Stopie: " << rankNames[ (int) _rank ] << endl;
   cout << "Wydzia: " << departmentNames[ (int) _department] << endl;
}


