#include "GradTeachingAsst.h"

TGradTeachingAsst::TGradTeachingAsst(const char theName[],
   unsigned long thePESEL, // doktoranta
   const char theBirthDate[], 
   const char theAddress[],
   EStudentStatus theStatus,
   EDepartment studentDepartment,
   const TTeacher& advisorInCharge,
   EDepartment teachingDept)
// Inicjalizuje bezporedni klas bazow TGraduateStudent
   : TGraduateStudent(theName, thePESEL, theBirthDate, theAddress,
      theStatus, studentDepartment, advisorInCharge),
// Inicjalizuje bezporedni klas bazow TTeacher
   TTeacher(theName, thePESEL, theBirthDate, theAddress,
      eGraduateTeachingAssistant, teachingDept),
// Inicjalizuje wirtualn klas bazow TPerson
   TPerson(theName, thePESEL, theBirthDate, theAddress) 
{
// Implementacja kodu dla klasy TGradTeachingAsst
}

TGradTeachingAsst::~TGradTeachingAsst()
{

}

void 
TGradTeachingAsst::Print() const
{
// Pobiera odpowiednie dane i wywietla je
   EStudentStatus studentStats = GetStatus();
   EDepartment studentDepartment = TGraduateStudent::GetDepartment();
   EDepartment teachingDepartment = TTeacher::GetDepartment();

   cout << "Imi i nazwisko: " << TPerson::GetName() << endl;
   cout << "Doktorant" << endl;
   cout << "Wydzia na ktrym studiuje: " << departmentNames[(int)studentDepartment] << 
      endl;
   cout << "Wydzia na ktrym prowadzi zajcia: " << 
      departmentNames[(int)teachingDepartment] << endl;
}

void
TGradTeachingAsst::SetStudentsDepartment(EDepartment dept)
   { TStudent::SetDepartment(dept); }
EDepartment
TGradTeachingAsst::GetStudentsDepartment() const
{ return TStudent::GetDepartment(); }

void
TGradTeachingAsst::SetTeachingDepartment(EDepartment dept)
{ TTeacher::SetDepartment(dept); }
EDepartment
TGradTeachingAsst::GetTeachingDepartment() const
{ return TTeacher::GetDepartment(); }

bool
TGradTeachingAsst::SetRank(ERank newRank)
{
// Nic nie robi, poniewa nie mona zmieni stopnia naukowego
// doktoranta. Zawsze jest to stopie eGraduateTeachingAssistant, 
// ktry ustawiony jest w konstruktorze.
   cout << "Bd: nie mona zmieni stopnia obiektu TGradTeachingAsst" << endl;
return false;
}

