#include "RangeInt.h"
#include <ostream.h>

/*
   Dostpne formaty wejciowe dla liczb klasy TRangeInt:
   warto
   (min, max)
   (min, warto, max)
   To jest bardzo prosta implementacja, majca na celu jedynie zilustrowanie schematu
   implementacji. W przypadku bdnych danych wejciowych nie jest przeprowadzana
   adna analiza bdw. 
*/
istream& TRangeInt::StreamIn(istream& is)
{
   int value = 0, low = eLow, high = eHigh;
   char c; // do odczytu ze strumienia

   is >> c; // odczytaj pierwszy znak
   if (c == '(') {
      // Uytkownik poda jedynie granice zakresu lub zarwno granice, jak i warto.
      // Musimy odczyta pozostae dane i sprawdzi, co zostao okrelone.
      is >> low >> c; // odczytaj (prawdopodobnie) doln granic oraz nastpny znak
      if (c == ',')
         is >> value >> c; // odczytaj warto (prawdopodobnie) oraz nastpny znak
      if (c == ')' ) {
         // Uytkownik poda jedynie granice zakresu, a nie warto obiektu klasy
         // TRangeInt.
         high = value;
         value = low; // ustaw warto na doln granic, poniewa nie wiemy,
                      // jaka ona powinna by
      }
      else if (c == ',') { // uytkownik poda wszystkie trzy wartoci
         is >> high >> c;
         if (c != ')') {
            // Bdny format danych wejciowych. Ustaw bdny stan strumienia.
            is.clear(ios::badbit);
         }
      }
   }
   else {
      // Uytkownik poda sam warto. Najpierw trzeba zwrci do strumienia
      // ostatni odczytany znak, poniewa jest on czci wartoci.
      is.putback(c);
      is >> value;
   }
   if (is) { // jeli strumie jest nadal w dobrym stanie (brak bdw)
      if (low >= high)
         return is; // mona by w tym miejscu zgosi wyjtek (szczegy w rozdziale 10)
      if (value >= low && value <= high)
         this->_value = value; // warto mieci si w granicach zakresu
      else return is; // bdne granice zakresu
      this->_low = low;
      this->_high = high;
   }
   return is;
}

TRangeInt::TRangeInt(int vlow, int vhigh, int val) {
   _value=val;
   _high=vhigh;
   _low=vlow;
}

TRangeInt::TRangeInt(int val=0) {
   _value=val;
   _high=eHigh;
   _low=eLow;
}

// Funkcja przekazujca do operatora pobierania.
istream& operator>>(istream& is, TRangeInt& ri)
{
   // Przeka wywoanie do funkcji skadowej StreamIn.
   return (ri.StreamIn(is));
}

// Normalna funkcja suca do wstawiania obiektu klasy TRangeInt do podanego
// strumienia. Parametr theStream reprezentuje obiekt klasy ostream, do ktrego
// obiekt ri klasy TRangeInt jest wysyany. Funkcja zwraca strumie theStream,
// aby moliwe byo kaskadowe stosowanie operatora. Jest to po prostu funkcja
// przekazujca.
ostream& operator<<(ostream& theStream, const TRangeInt& ri)
{
   // Przeka po prostu wywoanie do funkcji skadowej StreamOut klasy TRangeInt
   // (patrz (1) powyej). To takie proste.

   return (ri.StreamOut(theStream));
}
