#include <iostream>
#include <stdlib.h>

#include "String.h"
#include "BankAccountAsset.h"
#include "AutomobileAsset.h"

using namespace std;

float
ComputeTotalWorth( TPersonalAsset *assets[], unsigned size)
{
   // assets to tablica wskanikw do obiektw TPersonalAsset
   // size to liczba elementw w tablicy

   float totalWorth = 0.0;
  
   /* Kady element tablicy wskanikw assets wskazuje na obiekt jednej z klas pochodnych klasy
      TPersonalAsset. Dla wszystkich tych elementw wywoywana jest funkcja ComputeNetWorth.
      Mechanizm wizania dynamicznego wybiera dla obiektu poprawn wersj metody. */

   for (int i = 0; i < size; i++)
   /* Wywouje wirtualn funkcj dla obiektu jednej z klas pochodnych. assets[i] to wskanik
      do obiektu typu TPersonalAsset. Warto kadego obiektu dodawana jest do wartoci 
      cakowitej. Powtarza si to dla wszystkich elementw tablicy. */
      if (assets[i] != 0)
         totalWorth += assets[i]->ComputeNetWorth();
   
   return totalWorth;
}


int main(int argc, char *argv[])
{
  // Ponisza deklaracja nie skompiluje si, poniewa klasa TPersonalAsset jest abstrakcyjna
   // TPersonalAsset someAsset;

   TBankAccountAsset myAccount("John Wayne", 4555, 2500, 5.0, 
      "01-01-95");
   TAutomobileAsset Ford_Taurus(16000, "WAR2410", "22-03-94", 17000);
   TAutomobileAsset Mercedes_S400(10500, "KRA3200", "20-06-89", 45000);

   // Inicjalizuje tablic wskanikw myAssets. Uywa do tego utworzonych powyej obiektw
   TPersonalAsset* myAssets[] = { &Ford_Taurus, &Mercedes_S400, &myAccount };

   float myTotalWorth;
   myTotalWorth = ComputeTotalWorth(myAssets, 3);
   cout << "Cakowita warto zasobw to: " << myTotalWorth << " PLN" << endl;

  system("PAUSE");	
  return 0;
}
