#include "Person.h"
#include "Course.h"

// Uniwersytet rekrutuje na rne rodzaje studiw. To wyliczenie
// klasyfikuje je
enum EStudentStatus { eFullTime, ePartTime, eExchange };

// Student moe zapisa si na kilka kursw w cigu semestru
const short MAX_COURSES_FOR_STUDENT = 5;

using namespace std;

class TStudent : public TPerson {
   // W TPerson implementuje si lew stron rysunku 5.1
   public:
      TStudent(const char theName[],
         unsigned long thePESEL,
         const char theBirthDate[],
         const char theAddress[],
         EStudentStatus theStatus,
         EDepartment theDepartment);
      // Konstruktor kopiujcy
      TStudent(const TStudent& source);
      TStudent& operator=(const TStudent& source);
      ~TStudent();

      // Metody klasy TPerson nie s duplikowane
      void SetDepartment(EDepartment dept);
      EDepartment GetDepartment() const;

      bool EnrollForCourse(const TCourse& aCourse);
      bool DropFromCourse(const TCourse& theCourse);
      void ListCoursesRegisteredFor() const;

      void Print() const;
      // wiele innych szczegw pominito
   private:
      // To samo co w poprzedniej implementacji
      // Ale nie trzeba duplikowa danych, ktre
      // znajduj si w klasie TPerson
      EStudentStatus _status;
      EDepartment _department;
      // Tablica wskanikw do kursw studenta
      TCourse* _enrolled[MAX_COURSES_FOR_STUDENT];
      int _numCourses; // liczba kursw studenta
};
