#ifndef _STRING_H
#define _STRING_H

/*
* Plik nagwkowy klasy String. Oparta jest na zbiorze znakw ASCII.
* Obiekty TString mona kopiowa i przypisywa. Klasa implementuje gbokie kopiowanie.
* Obiekty tej klasy mog by tworzone w dowolnym miejscu.
* Mona uywa tej klasy w zamiast acuchw znakw ograniczonych cudzysowami ""
*/
#include <iostream>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

using namespace std;

class TString {
   public:
      // Konstruktory
      // Tworzy pusty obiekt TString
      TString();
      // Tworzy nowy acuch, ktry zawiera znaki wskazywane przez s.
      // s musi si koczy zerem. Znaki kopiowane s z s.
      TString(const char* s);
      // Tworzy obiekt TString zawierajcy jeden znak aChar
      TString(char aChar);
      TString(const TString& arg); // konstruktor kopiujcy
      ~ TString(); // Destruktor
      // Operatory przypisania
      TString& operator=(const TString& arg);
      TString& operator=(const char* s);
      TString& operator=(char s);
      // Zwraca liczb znakw przechowywanych aktualnie przez obiekt
      int Size() const;
      // Zwraca cz acucha od pozycji posn o dugoci len znakw.
      TString operator()(unsigned posn, unsigned len) const;
      // Zwraca znak na pozycji n
      char operator()(unsigned n) const;
      // Zwraca referencj do znaku na pozycji n
      const char& operator[] (unsigned) const;
      // Zwraca wskanik do wewntrznych danych. Zalecana ostrono.
      const char* c_str() const {return _str; }
      // Ta metoda modyfikuje oryginalny obiekt
      // Dodaje znaki ze zmiennej other do *this
      TString& operator+=(const TString& other);
      // Zmienia wielko wszystkich znakw w acuchu
      TString& ToLower(); // zmienia due litery na mae
      TString& ToUpper(); // zmienia mae litery na due
   private:
      // length jest liczb znakw przechowywanych przez obiekt.
      // Ale pami wskazywana przez str ma dugo przynajmniej length+1
      unsigned _length;
      char* _str; // wskanik do znakw
};
// Funkcje, ktra nie s skadowe, ale obsuguj klas TString
// Zwraca nowy obiekt TString, ktry jest zoeniem obiektw one i two
TString operator+(const TString& one, const TString& two);
// Operatory wejcia-wyjcia. W rozdziale 7. znajduje si szczegowa analiza.
ostream& operator<<(ostream& o, const TString& s);
istream& operator>>(istream& stream, TString& s);
// Operatory relacji. Porwnywanie odbywa si w oparciu o zbir znakw ASCII.
// Dwa obiekty TString s rwne, jeli zawieraj te same znaki.
int operator==(const TString& first, const TString& second);
int operator!=(const TString& first, const TString& second);
bool operator<(const TString& first, const TString& second);
bool operator>(const TString& first, const TString& second);
bool operator>=(const TString& first, const TString& second);
bool operator<=(const TString& first, const TString& second);

#endif
