#ifndef _DATE_H
#define _DATE_H

class TDate {
   public:
      enum EMonth { eJan=1, eFeb, eMar, eApr, eMay, eJun, eJul,
         eAug, eSep, eOct, eNov, eDec };
      // proste konstruktory
      TDate(unsigned day, EMonth mon, unsigned year);
      TDate(const char date[]); // data przekazywana jako acuch znakw
      TDate(); // ustawia dat na podstawie daty systemowej

      unsigned GetYear() const;
      EMonth GetMonth() const;
      unsigned GetDay() const; // dzie miesica

      // funkcje uatwiajce uywanie klasy
      void AddToYear(int increment); // mona doda liczb ujemn
      void AddToMonth(int increment); // mona doda liczb ujemn
      void AddToDay(int increment); // mona doda liczb ujemn
      // operatory porwnania
      bool operator==(const TDate& second) const;
      bool operator!=(const TDate& second) const;
      TString GetDate() const; // zwraca acuch znakw
   private:
      short _year; // dane implementacji
      short _day;
      EMonth _month;
};

#endif
