template <class AType> class TListNode;

template <class AType> class TList {
   public:
      TList() : _count(0),_head(0),_tail(0) {};
      TList(const AType* storeThisElement);
      TList(const TList<AType>& copy);
      TList& operator=(const TList<AType>& assign);
      ~TList() {};

      // Ile elementw zapisano na licie?
      unsigned int HowMany() const;
      // Docz do listy nowy wze (od strony ogona).
      // W przypadku powodzenia zwr warto true.
      bool Append (AType* newElementToAdd);
      // Wstaw na pocztek listy nowy wze (od strony gowy).
      // W przypadku powodzenia zwr warto true.
      bool Prepend (AType* newElementToAdd);
      AType* Remove(const AType* elementToRemove);
      bool Exists(const AType& thisObject) const;
      // i wiele innych metod
   private:
      TListNode<AType>* _head;
      TListNode<AType>* _tail;
      unsigned int _count;
};

template <class AType> class TListNode {
   public:
      // konstruktor tworzcy nowy obiekt TListNode dla podanych danych uytkownika
      TListNode(AType* userDataPointer=0);
      // konstruktor kopiujcy, itd.

      // Dla uproszczenia pominito pozostae szczegy.
   private:
      TListNode<AType>* _next;
      TListNode<AType>* _previous;
      AType* _userData; // wskanik danych dostarczonych przez uytkownika
      friend class TList<AType>; // wicej na ten temat pniej
};

template <class AType>
TListNode<AType>::TListNode(AType* userDataPointer=0)
{
    _userData=userDataPointer;
    _next=_previous=0;
}

template <class AType>
TList<AType>::TList(const AType* storeThisElement)
{
   // Utwrz dla podanego elementu nowy obiekt klasy TListNode.
   TListNode<AType>* newNode =
      new TListNode<AType>(newElementToAdd);
   _head=_tail=newNode;
   _count=1;
}

template <class AType>
TList<AType>::TList(const TList<AType>& copy)
{
   _head=copy._head;
   _tail=copy._tail;
   _count=copy._count;
}

template <class AType>
bool TList<AType>::Append (AType* newElementToAdd)
{
   // Utwrz dla podanego elementu nowy obiekt klasy TListNode.
   TListNode<AType>* newNode =
      new TListNode<AType>(newElementToAdd);

   // Wykonaj odpowiednie operacje na wskanikach, aby wstawi nowy element na koniec listy.
   newNode->_previous = this->_tail; // dotychczasowy "ogon" bdzie teraz przedostatni
   this->_tail->_next = newNode;     // dostosuj wskaniki
   _tail = newNode;                  // nasz nowy element jest ogonem listy
   _count++;

   return true;
}

template <class AType>
bool TList<AType>::Prepend (AType* newElementToAdd)
{
   // Utwrz dla podanego elementu nowy obiekt klasy TListNode.
   TListNode<AType>* newNode =
      new TListNode<AType>(newElementToAdd);

   // Wykonaj odpowiednie operacje na wskanikach, aby wstawi nowy element na pocztek listy.
   newNode->_next = this->_head;     // dotychczasowa "gowa" jest teraz drugim elementem
   this->_head->_previous = newNode; // dostosuj wskaniki
   _head = newNode;                  // nasz nowy element jest gow listy
   _count++;

   return true;
}

template <class AType>
AType* TList<AType>::Remove(const AType* elementToRemove)
{
   TListNode<AType>* currentNode = _head;
   AType* result = 0;
   while (currentNode != 0) {
      // Porwnaj adres obiektu na licie z obiektem uytkownika.
      if (currentNode->_userData == elementToRemove) {
         // Teraz odcz wze od listy (manipulacje na wskanikach).
         // Kod pominito, aby zachowa prostot tego przykadu.
         // Na koniec usu ten wze.
         delete currentNode; // Pamitajmy, e wze ten zosta alokowany dynamicznie
                             // przy dodawaniu nowego elementu do listy.
      }
   }
   return result;
}

template <class AType>
bool TList<AType>::Exists(const AType& thisObject) const
{
   TListNode<AType>* currentNode = _head;
   while (currentNode != 0) {
      // Porwnaj adres obiektu na licie z obiektem uytkownika.
      if (currentNode->_userData == &thisObject) {
         return true; // znaleziono obiekt
      }
      currentNode = currentNode->_next;
   }
   return false; // wyszukiwanie zakoczyo si niepowodzeniem
}

