// Wskanik ze zliczaniem odwoa wykorzystujcy przecione funkcje operator->
// oraz operator*. Ta implementacja NIE jest bezpieczna z punktu widzenia kodu
// wielowtkowego. Aby tak byo, definicja typedef ReferenceCount musiaaby by
// oddzieln klas.

typedef unsigned long ReferenceCount;

// Ta klasa istnieje jedynie po to, aby zminimalizowa zakres replikacji kodu.

class TCountedPtrImpl {
   protected:
      TCountedPtrImpl();
      TCountedPtrImpl(void* target);
      TCountedPtrImpl(const TCountedPtrImpl& copy);
      /*
       * Klasa pochodna musi zapewni prawidow implementacj swojego destruktora.
       * Destruktor klasy pochodnej powinien wywoywa metod RemoveReference(),
       * a nastpnie, jeli warto zwrcona jest rna od NULL, usun obiekt waciwy.
       * Klasa bazowa nie moe za to odpowiada, poniewa najpierw wywoywany jest
       * destruktor klasy pochodnej, a klasa bazowa nie zna typu wskanika
       * _targetPointer.
       */
      ~TCountedPtrImpl();

      TCountedPtrImpl& operator=(const TCountedPtrImpl& assign);
      // Zwraca TRUE, jeli obiekt jest wskanikiem do niezerowego obiektu nadrzdnego.
      bool IsValid() const { return _targetPointer != 0; }
      bool operator==(const TCountedPtrImpl& other) const;
      bool operator!=(const TCountedPtrImpl& other) const
      { return !(*this == other); }

      // Dodaj do obiektu jeszcze jedno odwoanie.
      void AddReference();

      // Zwr wskanik obiektu wasciwego, jeli zlikwidowano ostatnie odwoanie - 
      // w przeciwnym razie zwr 0. Po usuniciu ostatniego odwoania, klasa pochodna
      // powinna usun obiekt waciwy.
      void* RemoveReference();
      void* GetTarget() const { return _targetPointer; }

      // Wspomaganie testowania.
      int GetReferenceCount() const { return *_refCount; }
   private:
      ReferenceCount* _refCount;
      void* _targetPointer;
};

TCountedPtrImpl::TCountedPtrImpl() :
    _targetPointer(0), _refCount(0) { /* nie trzeba nic wicej robi */ }

TCountedPtrImpl::TCountedPtrImpl(void* target) :
   _targetPointer(target), _refCount(0)
{
   AddReference();
}

TCountedPtrImpl::TCountedPtrImpl(const TCountedPtrImpl& copy) :
   _targetPointer(copy._targetPointer), _refCount(copy._refCount)
{
   AddReference();
}

TCountedPtrImpl::~TCountedPtrImpl()
   { /* Wszystkie operacje wykonuje klasa pochodna. */ }

TCountedPtrImpl&
TCountedPtrImpl::operator=(const TCountedPtrImpl& that)
{
   RemoveReference();
   this->_targetPointer = that._targetPointer;
   this->_refCount = that._refCount;
   AddReference();

   return *this;
}

bool
TCountedPtrImpl::operator==(const TCountedPtrImpl& other) const
   { return (_targetPointer == other._targetPointer); }

void
TCountedPtrImpl::AddReference()
{
   if (_refCount) (*_refCount)++;
   else {
      _refCount = new ReferenceCount;
      *_refCount = 1;
   }
}

void*
TCountedPtrImpl::RemoveReference()
{
   if (_refCount) { 
      // Dekrementuj licznik odwoa i poinformuj kod wywoujcy, e liczba odwoa
      // spada do zera.
      (*_refCount)--;
      if (*_refCount == 0) {
         _refCount = 0;
         return _targetPointer; // zniko ostatnie odwoanie
      }
   }
   return 0; // to nie jest jeszcze ostatnie odwoanie
}

template <class AType>
class TCountedPointer : private TCountedPtrImpl
{
   public:
      TCountedPointer();
      TCountedPointer(AType* adoptTarget);
      TCountedPointer(const TCountedPointer<AType>& copy);
      ~TCountedPointer();
      TCountedPointer<AType>& operator=(const TCountedPointer<AType>& assign);

      // Ponownie eksportowane skadowe klasy bazowej.
      // Krtkie omwienie przestrzeni nazw mona znale w dodatku.
      using TCountedPtrImpl::IsValid;
      bool operator==(const TCountedPointer<AType>& other) const
      { return TCountedPtrImpl::operator==(other); }
      bool operator!=(const TCountedPointer<AType>& other) const
      {
         return !(*this == other);
      }

      AType& operator*() const;
      AType* operator->() const;
      // Wycznie dla celw testowania.
      using TCountedPtrImpl::GetReferenceCount;
};

template <class AType>
AType&
TCountedPointer<AType>::operator*() const
{
   // Musimy tutaj zastosowa jawne rzutowanie, poniewa wskanik _targetPointer
   // w klasie bazowej jest typu void*. Ta funkcja zwraca jednak typ AType&.
   // To rzutowanie jest bezpieczne, poniewa wskanik _targetPointer zosta ustawiony
   // przez nas i na pewno jest typu AType*.
   // Informacje na temat mechanizmu RTTI oraz operatora reinterpret_cast znale mona
   // w rozdziale 6.

   return *( reinterpret_cast<AType*>(GetTarget()) ); 
}

template <class AType>
AType*
TCountedPointer<AType>::operator->() const
{
   // Patrz komentarz dla funkcji operator*. Dotyczy on take tej funkcji.
   return reinterpret_cast<AType*>(GetTarget());
}

template <class AType>
TCountedPointer<AType>::~TCountedPointer()
{
   if (void* targetP = TCountedPtrImpl::RemoveReference()) {
      // Zniko ostatnie odwoanie.
      delete reinterpret_cast<AType*>(targetP);
   }
}

template <class AType>
TCountedPointer<AType>::TCountedPointer()
{
   // Nic nie trzeba robi. Automatyczne wywoanie konstruktora klasy bazowej.
}

template <class AType>
TCountedPointer<AType>::TCountedPointer(AType* adoptTarget)
   : TCountedPtrImpl(adoptTarget)
{
   // Nic wicej nie trzeba robi.
}

template <class AType>
TCountedPointer<AType>::TCountedPointer(const TCountedPointer<AType>& copy)
   : TCountedPtrImpl(copy)
{
   // Nic wicej nie trzeba robi.
}

template <class AType>
TCountedPointer<AType>&
TCountedPointer<AType>::operator=(const TCountedPointer<AType>& that)
{
   if (this != &that)
      TCountedPtrImpl::operator=(that);

   return *this;
}

