#include <iostream>
#include "IntStack.h"

using namespace std;

TIntStack::TIntStack(unsigned int stackSize /* = DEFAULT_SIZE */ )
{
   // Alokuje pami tylko wtedy, kiedy warto argumentu stackSize jest dodatnia
   if (stackSize > 0) {
      _size = stackSize;
      _sp = new int[_size]; // Alokuje pami dla elementw stosu
      // Przypisuje warto pocztkow elementom stosu
      for (int i=0; i < _size; i++)
         _sp[i] = 0;
   }
   else {
      _sp = 0; // ustawia wskanik na unikatow warto
      _size = 0;
   }
   _count = 0; // na stosie nie ma adnych elementw
}

TIntStack::TIntStack(const TIntStack& source)
{
   // Kod, ktry napisany jest w tym miejscu, posiada dostp do wszystkich regionw
   // klasy TIntStack, poniewa konstruktor kopiujcy jest funkcj skadow klasy.
   // Argument source jest obiektem typu TIntStack.
   _size = source._size;
   if (_size > 0) { // Alokuje pami tylko wtedy, kiedy rozmiar jest wikszy od zera
      _sp = new int[_size]; // Alokuje pami dla elementw stosu
   
      _count = source._count; // Liczba elementw na stosie

      // Nastpnie kopiuje wszystkie elementy z obiektu source na nowy stos
      for (int i = 0; i < _count; ++i)
         _sp[i] = source._sp[i];
   }
   else {
      _sp = 0; // ustawia wskanik na unikatow warto
      _count = 0; // nie ma elementw na stosie
   }
}

TIntStack& TIntStack::operator=(const TIntStack& source)
{
   // Sprawdza przypisanie do samego siebie w formie a = a. 'this' to adres obiektu, 
   // do ktrego przypisywana jest warto i jednoczenie rdo przypisywanego obiektu.
   // &source daje adres obiektu.
   if (this == &source) {
      cout << "Uwaga: przypisanie do siebie.\n";
      return *this;
   }

   /*
   Jeli liczba elementw w rdowym stosie jest rwna lub mniejsza od rozmiaru obiektu 
   docelowego, to dobrze. Wystarczy wtedy przekopiowa odpowiednie elementy stosu i 
   zmienn count. Z drugiej strony jeli liczba elementw stosu rdowego jest wiksza 
   ni rozmiar stosu docelowego, to trzeba zwolni pami zajmowan przez obiekt 
   docelowy, a nastpnie zaalokowa odpowiedni rozmiar pamici i skopiowa wszystkie 
   elementy.
   */
   if (source._count > this->_size) {
      // Liczba elementw w obiekcie source jest wiksza ni rozmiar obiektu docelowego
      // Zwalniana jest pami zajmowana przez _sp i alokowana jest nowa
      // Objanienie znajduje si poniej
      delete [] _sp;
      this->_size = source._size;
      _sp = new int [ this->_size ];
   }
      // Ten fragment jest wsplny dla obu opisanych przypadkw. 
      // Przechodzi po stosie i kopiuje elementy
      for (int i = 0; i < source._count; i++)
         this->_sp[i] = source._sp[i]; // kopiuje elementy
      this->_count = source._count;

      return *this; // Objanienie znajduje si poniej
}

TIntStack::~TIntStack()
{
   cout << "Dziaa destruktor klasy TIntStack\n";
   delete [] _sp;
}


void TIntStack::Push(int what)
{
   if (_count < _size) { // Jeli jest miejsce na kolejny element
      _sp[_count] = what; // zapisuje element
      _count++; // zwiksza licznik
   }
   else {
      cout << "Stos jest peny. Nie mona doda elementu " << what << endl;
   }
}
int TIntStack::Pop()
{
   if (_count <= 0) { // Stos jest pusty
      cout << "Stos jest pusty\n";
      exit (1); // Jak inaczej mona wskaza bd?
      // W komercyjnym programie tutaj zgaszany byby wyjtek
   }
   _count--;
   return _sp[_count];
}

unsigned TIntStack::HowMany() const
{
   return _count;
}

