#include <stdlib.h> // wszystkie funkcje z biblioteki jzyka C
#include <iostream.h>

// Tablica o rozmiarze ARRAY_SIZE zostaje utworzona w przypadku, gdy uytkownik nie poda rozmiaru
const unsigned int ARRAY_SIZE = 256;

class TSafeArray {
   public:
      TSafeArray(unsigned int arraySize = ARRAY_SIZE);
      TSafeArray(const TSafeArray& copy); // konstruktor kopiujcy
      virtual ~TSafeArray(); // destruktor
      // operator przypisania
      TSafeArray& operator=(const TSafeArray& assign);

      // Jaki jest rozmiar tablicy?
      unsigned int GetSize() const { return _size; }
      // operatory indeksowania
      const int& operator[](int index) const; // wersja "tylko do odczytu"
      int& operator[](int index); // do odczytu i zapisu
      // oraz wiele innych funkcji skadowych
   private:
      int _size;
      int* _ip;
};

ostream& operator<<(ostream& stream, const TSafeArray& object);

// Implementacja funkcji skadowych

TSafeArray::TSafeArray(unsigned int arraySize)
{
   // Jeli parametr arraySize jest prawidowy, alokujemy pami na tablic
   // i inicjalizujemy j zerami. W przeciwnym razie ustawiamy wskanik na 0.
   if (arraySize > 0) {
      _size = arraySize;
      _ip = new int(_size);
      for(int i=0; i < _size; i++)
         *(_ip+i) = 0;
   }
   else {
      _ip = 0;
      _size = 0;
   }
}

TSafeArray::~TSafeArray()
{
   // Po prostu zwolnij pami alokowan w konstruktorze.
   if (_ip != 0)
      delete [] _ip;
}

// To jest konstruktor kopiujcy wywoywany przez system przy kopiowaniu obiektw.
TSafeArray::TSafeArray(const TSafeArray& copy)
{
   // Jeli rozmiar _size obiektu tablicy rdowej jest dodatni, alokuj pami na nowy obiekt tablicy
   // i przekopiuj wszystkie elementy.
   if (copy._size > 0) {
      _size = copy._size;
      _ip = new int(_size);
      for(int i=0; i < _size; i++)
         *(_ip+i) = copy._ip[i]; // kopiowanie element po elemencie
   }
   else {
      _ip = 0;
      _size = 0;
   }
}

// Operator przypisania (dla wyrae typu a=b)
TSafeArray&
TSafeArray::operator=(const TSafeArray& assign)
{
   if (this == &assign) { // sprawd, czy nie przypisujemy obiektu do samego siebie
      cout << "Uwaga: prba przypisania obiektu do samego siebie\n";
      return *this;
   }
   // Jest moliwe, e rozmiar _size obiektu tablicy po prawej stronie nie jest taki sam jak obiektu po lewej

   // Obiekt po lewej jest wikszy od obiektu po prawej - nie ma problemu,
   // po prostu przekopiuj elementy.
   if (this->_size >= assign._size) {
      // Prosty przypadek - po prostu kopiujemy elementy.
      for(int i=0; i < assign._size; i++)
         _ip[i] = assign._ip[i];
      _size = assign._size;
   }
   else {
      // Obiekt po lewej stronie jest mniejszy - trzeba alokowa wicej pamici.
      // Najpierw zwolnij istniejc pami, a nastpnie alokuj now tablic.
      if (_ip != 0)
         delete [] _ip; // zwolnij istniejc pami
      this->_ip = new int[assign._size];
      this->_size = assign._size; // kopiuj take rozmiar
      for(int i=0; i < _size; i++)
         _ip[i] = assign._ip[i];
   }

   return *this;
}

// To jest wanie istotny operator. Uytkownicy z pewnoci bd zadowoleni
// z moliwoci korzystania z obiektw typu TSafeArray jak z prostej tablicy.
// Operator [] realizuje to bardzo atwo. Najwaniejsz jego cech jest zwracanie
// przez referencj.

int&
TSafeArray::operator[](int index)
{
   // Jeli indeks przekracza rozmiar tablicy (lub jest ujemny), operacja nie moe
   // zosta wykonana. Najlepszym wyjciem z takiej sytuacji byoby zgoszenie wyjtku
   // sygnalizujcego bd typu "Indeks poza zakresem". Poniewa jednak nie omawialimy
   // jeszcze wyjtkw, wywoamy po prostu funkcj exit. Jest to funkcja biblioteczna,
   // ktra przerywa wykonywanie programu.
   if (index < 0 || index >= _size) {
      cerr << "Bd krytyczny: indeks poza zakresem\n";
      cerr << "Rozmiar=" << _size << "  Indeks=" << index << endl;
      exit(1); // waciwie naleaoby w tym miejscu zgosi wyjtek
   }
   // Indeks jest prawidowy - po prostu zwr referencj do danego elementu.
   return _ip[index];
}

// To jest wersja funkcji operator[] przeznaczona tylko do odczytu.
const int& TSafeArray::operator[](int index) const
{
   if (index < 0 || index >= _size) {
      cerr << "Bd krytyczny: indeks poza zakresem\n";
      cerr << "Rozmiar=" << _size << "  Indeks=" << index << endl;
      exit(1); // waciwie naleaoby w tym miejscu zgosi wyjtek
   }
   // Indeks jest prawidowy - po prostu zwr referencj do danego elementu.
   return _ip[index];
}

ostream&
operator<<(ostream& stream, const TSafeArray& array)
{
   // Wysyaj elementy po kolei do strumienia.
   int j = array.GetSize();
   for (int i=0; i < j; i++) stream << array[i] << " "; // wykorzystuje operator[]
   return (stream << endl);
}

