#include <iostream>
#include "tgarage.h"
#include "tautomobile.h"
TAutomobile* FREE_SLOT = 0;


TGarage::TGarage(unsigned int howManySlots) {
    // Tworzymy tablic wskanikw pojazdw. Kady wskanik moe przechowywa
    // adres jednego obiektu klasy TAutomobile:
    if (howManySlots > 0) {
        _slots= new TAutomobile* [howManySlots];
        _freeSlots = _capacity = howManySlots;
        for(int i = 0; i < _capacity; i++)
            _slots[i] = FREE_SLOT;
    } else {
        _freeSlots = _capacity = 0;
        _slots = 0;
    }
}

TGarage::~TGarage() {
    delete [] _slots; /* nie zwalnia obiektw pojazdw na stanowiskach */
}

// Parkuje pojazd i zwraca numer stanowiska:
SlotNumber TGarage::Park(TAutomobile* parkVehicle)
{
    if (_freeSlots <= 0) return -1; // gara jest peen
    if (parkVehicle != 0) {
        for (int i = 0; i < _capacity; i++)
            if (_slots[i] == FREE_SLOT) {
                _slots[i] = parkVehicle;
                _freeSlots--;
                return i;
            }
    }
    // Lepiej byoby zgosi wyjtek
    return -1;
}

// Zwraca pojazd zaparkowany na danym stanowisku:
TAutomobile* TGarage::ReleaseVehicle(SlotNumber which)
{
    TAutomobile* released = 0;
    if (_slots[which] != 0) {
        released = _slots[which];
        _slots [which] = FREE_SLOT; // oznacza stanowisko jako wolne
        ++_freeSlots;
    }
    return released;
}

void TGarage::ListVehiclesParked() const
{
    for (int i = 0; i < _capacity; i++) {
        if (_slots[i] != FREE_SLOT) {
            std::cout << "Pojazd na stanowisku:" << i << " to: ";
            _slots[i]->PrintIdentity();
            std::cout << std::endl;
        }
    }
}
