#include <memory>
#include <iostream>

#include "tgarage.h"
#include "tautomobile.h"

using namespace std;  // potrzebne do wygodnego korzystania z cout

class TAutomobile;
typedef unsigned int SlotNumber;


void TestGarage()
{
    TCar*         aCar = new TCar("2MEB410");
    unsigned int aCarSlot;
    TVan*         aVan = new TVan("3EML110");
    unsigned int aVanSlot;

    // Utwrz gara na 400 pojazdw:
    auto_ptr<TGarage> theGarage(new TGarage(400));

    // Zaparkuj kilka pojazdw:
    aCarSlot = theGarage->Park(aCar);
    aVanSlot = theGarage->Park(aVan);
    theGarage->ListVehiclesParked();

    // Sprbuj odebra pojazd z parkingu podajc niepoprawny numer stanowiska
    auto_ptr<TAutomobile>
        ap = theGarage->ReleaseVehicle(10); // co si tu dzieje?
    cout << "ReleaseVehicle(10) dao: " << ap.get() << endl; // (1)

    ap = theGarage->ReleaseVehicle(aVanSlot); // (2)
    // Sprawd, czy gara zwrci waciwy pojazd:
    if (ap.get() != 0) { // (3)
        cout << "ReleaseVehicle(aVanSlot) dao: ";
        ap->PrintIdentity(); // (4)
        cout << endl;
    }
    else {
        cout << "ReleaseVehicle(aVanSlot) dao: " <<
            ap.get() << endl;
    }
    // Na koniec usu pozostae pojazdy z garau:
    auto_ptr<TAutomobile> bp = theGarage->ReleaseVehicle(aCarSlot);
    // Mona by rwnie napisa: ap = theGarage->ReleaseVehicle(aCarSlot);
    // dziaaoby to rwnie poprawnie, z uwagi na to, e operator przypisania auto_ptr
    // zwalnia dotychczas przetrzymywane zasoby lewej strony przypisania.
    if (bp.get() != 0) {
        cout << "ReleaseVehicle(aCarSlot) dao: " ;
        bp->PrintIdentity();
        cout << endl;
    }
    // Nie trzeba przejmowa si zwalnianiem zasobw
}

main()
{
    TestGarage();
}