// implementacja funkcji skadowej Print
#include <iostream>
#include "Int.h"

using namespace std;

// implementacja operatora +
TInt TInt::operator+(const TInt& operand) const
// TInt jest typem wartoci zwracanej przez wynik dziaania operatora
{
   /*
      Kod liczcy sum argumentu i liczby typu TInt, na ktrej wywoana zostaa
       funkcja operatora +. Liczba ta jest wskazywana 
przez wskanik this. Funkcja ta liczy sum obiektu *this i argumentu, a 
nastpnie zwraca sum jako now liczb typu TInt. Ani 
obiekt *this, ani argument nie s modyfikowane, poniewa uywany jest 
kwalifikator const. Funkcja dziaa wedug algorytmu:
1. dodaje do siebie czci _leastSignificantPart i przechowuje bit przeniesienia;
2. dodaje do siebie czci _mostSignificantPart korzystajc z bitu przeniesienia;
3. przechowuje wartoci (1) i (2) w pomocniczej liczbie typu TInt;
4. zwraca przez warto pomocnicz liczb TInt.
*/
   TInt result = *this;   //  wywouje konstruktor kopiujcy
   unsigned char carry = 0;

// Dodaje czci leastSignificant i sprawdza przeniesienie
result._leastSignificantPart += operand.GetLeastSignificantPart();
if ( result._leastSignificantPart <
      operand.GetLeastSignificantPart() )
      carry = 1;

   // Dodaje czci mostSignificant i przeniesienie
   result._mostSignificantPart += carry +
      operand.GetMostSignificantPart();

   return(result);
}

// Szkielet konstruktora
TInt::TInt(long msp, unsigned long lsp)
{
   // Kopiuje wartoci przekazane do konstruktora
   // do odpowiednich danych skadowych
   _leastSignificantPart = lsp;
   _mostSignificantPart = msp;
}

TInt::TInt(int value)
{ 
   _leastSignificantPart = value;
   _mostSignificantPart = 0;
}

TInt::TInt()
{ }

TInt::TInt(const TInt& copy)
{ }

TInt::~TInt()
{ }

void
TInt::Print() const
{
   // cout jest egzemplarzem klasy ostream, ktra jest standardow klas biblioteczn strumienia wejcia/wyjcia
   cout << "0x" << _mostSignificantPart << ", 0x" << _leastSignificantPart
      << endl;
    // jakiekolwiek przypisanie do danych skadowych jest w tej funkcji niedozwolone
}

void
TInt::FlipSign()
{
   _mostSignificantPart = -_mostSignificantPart;
}

long
TInt::GetMostSignificantPart() const
{ }

unsigned long 
TInt::GetLeastSignificantPart() const
{ }

TInt&
TInt::operator=(const TInt& assign)
{ }
